<?php

	class Application_Model_Mapper_Regioni extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_Regioni");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}

		public function fetchByZonaId($zona_id, $order = null) 
		{
			if(is_numeric($zona_id)) {
				return parent::fetchRow(array("zona_id = '".$zona_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("zona_id", "int"));
		}
		
		public function fetchRegioneComuniByEnteId($ente_id, $order = null)
		{
			$select = $this->getDbTable()->select()
										->from(array('r' 		=> 	Application_Model_DbTable_Regioni::_table_name), array('r.nome', 'r.regione_id', 'r.zona_id'))
										->joinInner(array('p'	=> 	Application_Model_DbTable_Province::_table_name), 'r.regione_id = p.regione_id', array())
										->joinInner(array('pc'	=>	Application_Model_DbTable_ProvinceHasComuni::_table_name), 'pc.provincia_id = p.provincia_id', array())
										->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = pc.comune_id', array())
										->joinInner(array('ec'	=>	Application_Model_DbTable_EntiHasComuni::_table_name), 'ec.comune_id = c.comune_id', array())
										->joinInner(array('e'	=>	Application_Model_DbTable_Enti::_table_name), 'e.ente_id = ec.ente_id', array())
										->group('r.nome')
										->order($order)
										->where('e.ente_id = '.$ente_id)
										->setIntegrityCheck(false);
			return parent::fetchRow($select, $order);
		}
		
		public function fetchProvinciaComuniByEnteId($ente_id, $order = null)
		{
			$select = $this->getDbTable()->select()
										->from(array('r' 		=> 	Application_Model_DbTable_Regioni::_table_name), array('p.nome', 'p.regione_id'))
										->joinInner(array('p'	=> 	Application_Model_DbTable_Province::_table_name), 'r.regione_id = p.regione_id', array())
										->joinInner(array('pc'	=>	Application_Model_DbTable_ProvinceHasComuni::_table_name), 'pc.provincia_id = p.provincia_id', array())
										->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = pc.comune_id', array())
										->joinInner(array('ec'	=>	Application_Model_DbTable_EntiHasComuni::_table_name), 'ec.comune_id = c.comune_id', array())
										->joinInner(array('e'	=>	Application_Model_DbTable_Enti::_table_name), 'e.ente_id = ec.ente_id', array())
										->group('r.nome')
										->order($order)
										->where('e.ente_id = '.$ente_id)
										->setIntegrityCheck(false);
			return parent::fetchRow($select, $order);
		}
		
		
		public function fetchRegioneProvinciaByEnteId($ente_id, $order = null)
		{
			$select = $this->getDbTable()->select()
										->from(array('r' 		=> 	Application_Model_DbTable_Regioni::_table_name), array('r.nome', 'r.regione_id', 'r.zona_id'))
										->joinInner(array('p'	=> 	Application_Model_DbTable_Province::_table_name), 'r.regione_id = p.regione_id', array())
										->joinInner(array('ep'	=>	Application_Model_DbTable_EntiHasProvince::_table_name), 'ep.provincia_id = p.provincia_id', array())
										->joinInner(array('e'	=>	Application_Model_DbTable_Enti::_table_name), 'e.ente_id = ep.ente_id', array())
										->order($order)
										->where('e.ente_id = '.$ente_id)
										->setIntegrityCheck(false);
			return parent::fetchRow($select, $order);
		}
		
		public function fetchRegioniEntiComuniAttivi($order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
										->from(array('r' 		=> 	Application_Model_DbTable_Regioni::_table_name), array('r.nome', 'r.regione_id'))
										->joinInner(array('p'	=> 	Application_Model_DbTable_Province::_table_name), 'r.regione_id = p.regione_id', array())
										->joinInner(array('pc'	=>	Application_Model_DbTable_ProvinceHasComuni::_table_name), 'pc.provincia_id = p.provincia_id', array())
										->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = pc.comune_id', array())
										->joinInner(array('ec'	=>	Application_Model_DbTable_EntiHasComuni::_table_name), 'ec.comune_id = c.comune_id', array())
										->joinInner(array('e'	=>	Application_Model_DbTable_Enti::_table_name), 'e.ente_id = ec.ente_id', array())
										->group('r.nome')
										->order($order)
										->limit($count, $offset)
										->where('e.attivo = 1')
										->setIntegrityCheck(false);
										
			return parent::fetchAll($select, $order, $count, $offset);
		}
		
	}
	
	