<?php

	class Application_Model_Mapper_Province extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_Province");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}

		public function fetchByProvinciaId($provincia_id, $order = null) 
		{
			if(is_numeric($provincia_id)) {
				return parent::fetchRow(array("provincia_id = '".$provincia_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("provincia_id", "int"));
		}
		
		public function fetchEntiProvinceAttiviByRegioneId($regione_id, $order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
										->from(array('r' 		=> 	Application_Model_DbTable_Regioni::_table_name), array('p.nome', 'ep.ente_id'))
										->joinInner(array('p'	=> 	Application_Model_DbTable_Province::_table_name), 'r.regione_id = p.regione_id', array())
										->joinInner(array('ep'	=>	Application_Model_DbTable_EntiHasProvince::_table_name), 'ep.provincia_id = p.provincia_id', array())
										->joinInner(array('e'	=>	Application_Model_DbTable_Enti::_table_name), 'e.ente_id = ep.ente_id', array())
										->order($order)
										->limit($count, $offset)
										->where('r.regione_id = '.$regione_id.' AND e.attivo = 1')
										->setIntegrityCheck(false);
			
			return parent::fetchAll($select, $order, $count, $offset);
		}
		
	}
	
	