<?php

	class Application_Model_Mapper_EventiHasCandidati extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_EventiHasCandidati");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}
		
		public function fetchByEventoId($evento_id, $order = null) 
		{
			if(is_numeric($evento_id)) {
				return parent::fetchRow(array("evento_id = '".$evento_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("evento_id", "int"));
		}

		public function fetchByCandidatoId($candidato_id, $order = null) 
		{
			if(is_numeric($candidato_id)) {
				return parent::fetchRow(array("candidato_id = '".$candidato_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("candidato_id", "int"));
		}

		public function fetchByPosizione($posizione, $order = null) 
		{
			if(is_numeric($posizione)) {
				return parent::fetchRow(array("posizione = '".$posizione."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("posizione", "int"));
		}
		
		public function fetchByVoti($voti, $order = null) 
		{
			if(is_numeric($voti)) {
				return parent::fetchRow(array("voti = '".$voti."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("voti", "int"));
		}
		
		public function fetchByPercentuale($percentuale, $order = null) 
		{
			if(is_numeric($percentuale)) {
				return parent::fetchRow(array("percentuale = '".$percentuale."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("percentuale", "int"));
		}
		
		public function fetchByEletto($order = null) 
		{
			return parent::fetchRow(array("eletto = 'E'"), $order);
		}
	}
	
	