<?php

	class Application_Model_Mapper_EntiHasProvince extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_EntiHasProvince");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}
		
		public function fetchByEnteId($ente_id, $order = null) 
		{
			if(is_numeric($ente_id)) {
				return parent::fetchRow(array("ente_id = '".$ente_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("ente_id", "int"));
		}
		
		public function fetchByProvinciaId($provincia_id, $order = null) 
		{
			if(is_numeric($provincia_id)) {
				return parent::fetchRow(array("provincia_id = '".$provincia_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("provincia_id", "int"));
		}

		public function fetchEnte($provincia_id, $order = null) 
		{
			if(is_numeric($provincia_id)) {
				$select = $this->getDbTable()->select()
					->from(array('e' => Application_Model_DbTable_Enti::_table_name))
					->joinLeft(array('p' => Application_Model_DbTable_EntiHasProvince::_table_name), "e.ente_id = p.ente_id")
					->setIntegrityCheck(false);
                                  
				$select->where("p.provincia_id = '".$provincia_id."'");
				
				return parent::fetchRow($select, $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("provincia_id", "int"));
		}
	}
	
	
