<?php

	class Application_Model_Mapper_EntiHasComuni extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_EntiHasComuni");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}
		
		public function fetchByEnteId($ente_id, $order = null) 
		{
			if(is_numeric($ente_id)) {
				return parent::fetchRow(array("ente_id = '".$ente_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("ente_id", "int"));
		}
		
		public function fetchByComuneId($comune_id, $order = null) 
		{
			if(is_numeric($comune_id)) {
				return parent::fetchRow(array("comune_id = '".$comune_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("comune_id", "int"));
		}
		
		public function fetchEnte($comune_id, $order = null) 
		{
			if(is_numeric($comune_id)) {
				$select = $this->getDbTable()->select()
                                  ->from(array('e' => Application_Model_DbTable_Enti::_table_name))
                                  ->joinLeft(array('c' => Application_Model_DbTable_EntiHasComuni::_table_name), "e.ente_id = c.ente_id")
                                  ->setIntegrityCheck(false);
                                  
				$select->where("c.comune_id = '".$comune_id."'");

				return parent::fetchRow($select, $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("comune_id", "int"));
		}
	}
	
	
