<?php

	class Application_Model_Mapper_Enti extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_Enti");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}

		public function fetchByDataOraAggiornamento($ente_id, $dataOraAggiornamento, $order = null) 
		{
			if(is_string($dataOraAggiornamento)) {
				return parent::fetchRow(array("ente_id = '".$ente_id."' AND dataOraAggiornamento = '".$dataOraAggiornamento."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("dataOraAggiornamento", "string"));
		}

		public function fetchByEventoId($evento_id, $order = null) 
		{
			if(is_numeric($evento_id)) {
				return parent::fetchRow(array("evento_id = '".$evento_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("evento_id", "int"));
		}
		
		public function fetchSeasComunali($data) 
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('phc.codice', 'phc.provincia_id', 'e.evento_id', 'ev.data'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ehc'	=> 	Application_Model_DbTable_EntiHasComuni::_table_name),'e.ente_id = ehc.ente_id', array())
				->joinInner(array('phc'	=>	Application_Model_DbTable_ProvinceHasComuni::_table_name), 'ehc.comune_id = phc.comune_id', array())
				->where('ev.tipo_evento_id = 1 AND e.attivo = 1 AND e.manuale = 0 AND ev.data = "' . $data . '"')->setIntegrityCheck(false);
				
			return parent::fetchAll($select);
		}

		public function fetchSeasProvinciali($data) 
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('ehp.provincia_id', 'e.evento_id', 'ev.data'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ehp'	=> 	Application_Model_DbTable_EntiHasProvince::_table_name),'e.ente_id = ehp.ente_id', array())
				->where('ev.tipo_evento_id = 2 AND e.attivo = 1 AND e.manuale = 0 AND ev.data = "' . $data . '"')->setIntegrityCheck(false);
				
			return parent::fetchAll($select);
		}
		
		public function fetchEntiProvinceAttivi($data, $order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('p.nome', 'e.ente_id', 'e.attivo', 'e.manuale'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ep'	=> 	Application_Model_DbTable_EntiHasProvince::_table_name),'e.ente_id = ep.ente_id', array())
				->joinInner(array('p'	=>	Application_Model_DbTable_Province::_table_name), 'p.provincia_id = ep.provincia_id', array())
				->order($order)
				->where('ev.tipo_evento_id = 2 AND e.attivo = 1 AND ev.data = "' . $data . '"')->setIntegrityCheck(false);

				//echo $select->__toString();
				//die();
			return parent::fetchAll($select, $order, $count, $offset);
		}
		
		public function fetchEntiComuniAttivi($data, $order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('c.nome', 'e.ente_id', 'e.attivo', 'e.manuale'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ec'	=> 	Application_Model_DbTable_EntiHasComuni::_table_name),'e.ente_id = ec.ente_id', array())
				->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = ec.comune_id', array())
				->order($order)
				->where('ev.tipo_evento_id = 1 AND e.attivo = 1 AND ev.data = "' . $data . '"')->setIntegrityCheck(false);

			return parent::fetchAll($select, $order, $count, $offset);
		}
		
		public function fetchDatiAggiornamentoEnteProvinceByEnteId($ente_id, $order = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('p.nome', 'e.*'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ep'	=> 	Application_Model_DbTable_EntiHasProvince::_table_name),'e.ente_id = ep.ente_id', array())
				->joinInner(array('p'	=>	Application_Model_DbTable_Province::_table_name), 'p.provincia_id = ep.provincia_id', array())
				->where('ev.tipo_evento_id = 2 AND e.attivo = 1 AND e.ente_id = '.$ente_id)->setIntegrityCheck(false);
			
			return parent::fetchRow($select, $order);
		}
		
		public function fetchDatiAggiornamentoEnteComuneByEnteId($ente_id, $order = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('c.nome', 'e.*'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ec'	=> 	Application_Model_DbTable_EntiHasComuni::_table_name),'e.ente_id = ec.ente_id', array())
				->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = ec.comune_id', array())
				->where('ev.tipo_evento_id = 1 AND e.attivo = 1 AND e.ente_id = '.$ente_id)->setIntegrityCheck(false);
			
			return parent::fetchRow($select, $order);
		}
		
		public function fetchDatiAggiornamentoCandidatiByEnteId($ente_id, $order = null) {
			if(is_numeric($ente_id)) {
				$select = $this->getDbTable()->select()
					->from(array('c' => Application_Model_DbTable_Candidati::_table_name), array('e.id', 'c.candidato_id','c.nome', 'c.cognome', 'c.data_nascita', 'c.luogo_nascita', 'e.posizione', 'e.voti', 'e.percentuale', 'e.eletto'))
					->joinInner(array('e'	=> 	Application_Model_DbTable_EntiHasCandidati::_table_name),'c.candidato_id = e.candidato_id', array())
					->where('ente_id = "' . $ente_id .'"')->setIntegrityCheck(false);
				
				return parent::fetchAll($select, $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("ente_id", "int"));
		}
		
		public function fetchDatiAggiornamentoListeByCandidatoId($candidato_id, $order = null, $count = null, $offset = null)
		{
			if(is_numeric($candidato_id)) {
				$select = $this->getDbTable()->select()
					->from(array('c' => Application_Model_DbTable_Candidati::_table_name), array('cl.*', 'l.*'))
					->joinInner(array('cl'	=> 	Application_Model_DbTable_CandidatiHasListe::_table_name),'c.candidato_id = cl.candidato_id')
					->joinInner(array('l'	=>	Application_Model_DbTable_Liste::_table_name), 'cl.lista_id = l.lista_id')
					->where('cl.candidato_id = "' . $candidato_id .'"')->setIntegrityCheck(false);
				return parent::fetchAll($select, $order, $count, $offset);
			}
		}
		
		public function fetchDatiAggiornamentoEntiAttiviProvincia($order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('p.nome', 'e.*', 'UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(e.dataOraAggiornamentoManuale)  AS differenza'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ep'	=> 	Application_Model_DbTable_EntiHasProvince::_table_name),'e.ente_id = ep.ente_id', array())
				->joinInner(array('p'	=>	Application_Model_DbTable_Province::_table_name), 'p.provincia_id = ep.provincia_id', array())
				->where('ev.tipo_evento_id = 2 AND e.attivo = 1')
				->limit($count, $offset)
				->order($order)
				->setIntegrityCheck(false);
			  return parent::fetchAll($select);
		}
		
		public function fetchDatiAggiornamentoEntiAttiviComuni($order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('c.nome', 'e.*', 'UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(e.dataOraAggiornamentoManuale)  AS differenza'))
				->joinInner(array('ev'	=> 	Application_Model_DbTable_Eventi::_table_name),'e.evento_id = ev.evento_id', array())
				->joinInner(array('ec'	=> 	Application_Model_DbTable_EntiHasComuni::_table_name),'e.ente_id = ec.ente_id', array())
				->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = ec.comune_id', array())
				->where('ev.tipo_evento_id = 1 AND e.attivo = 1')
				->limit($count, $offset)
				->order($order)
				->setIntegrityCheck(false);
			  return parent::fetchAll($select);
		}

		public function fetchCandidati($ente_id, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
				->from(array('e' => Application_Model_DbTable_Enti::_table_name), array('c.nome', 'c.cognome' , 'ec.voti', 'ec.percentuale', 'ec.eletto'))
				->joinInner(array('ec'	=> 	Application_Model_DbTable_EntiHasCandidati::_table_name),'e.ente_id = ec.ente_id', array())
				->joinInner(array('c'	=>	Application_Model_DbTable_Candidati::_table_name), 'c.candidato_id = ec.candidato_id', array())
				->where('e.ente_id = ' . $ente_id)
				->limit($count, $offset)
				->order('ec.posizione DESC')
				->setIntegrityCheck(false);
			  return parent::fetchAll($select);
		}
	}
	
	
