<?php

	class Application_Model_Mapper_Comuni extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_Comuni");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}
		
		public function fetchByNome($nome, $order = null) 
		{
			if(is_string($nome)) {
				return parent::fetchRow(array("nome = '".$nome."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("nome", "string"));
		}
		
		public function fetchEntiComuniAttiviByRegioneId($regione_id, $order = null, $count = null, $offset = null)
		{
			$select = $this->getDbTable()->select()
										->from(array('r' 		=> 	Application_Model_DbTable_Regioni::_table_name), array('c.nome', 'ec.ente_id'))
										->joinInner(array('p'	=> 	Application_Model_DbTable_Province::_table_name), 'r.regione_id = p.regione_id', array())
										->joinInner(array('pc'	=>	Application_Model_DbTable_ProvinceHasComuni::_table_name), 'pc.provincia_id = p.provincia_id', array())
										->joinInner(array('c'	=>	Application_Model_DbTable_Comuni::_table_name), 'c.comune_id = pc.comune_id', array())
										->joinInner(array('ec'	=>	Application_Model_DbTable_EntiHasComuni::_table_name), 'ec.comune_id = c.comune_id', array())
										->joinInner(array('e'	=>	Application_Model_DbTable_Enti::_table_name), 'e.ente_id = ec.ente_id', array())
										->order($order)
										->limit($count, $offset)
										->where('r.regione_id = '.$regione_id.' AND e.attivo = 1')
										->group('c.comune_id')
										->setIntegrityCheck(false);
										
			return parent::fetchAll($select, $order, $count, $offset);
		}
		
	}
	
	