<?php

	class Application_Model_Mapper_CandidatiHasListe extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_CandidatiHasListe");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}
		
		public function fetchByCandidatoId($candidato_id, $order = null) 
		{
			if(is_numeric($candidato_id)) {
				return parent::fetchRow(array("candidato_id = '".$candidato_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("candidato_id", "int"));
		}
		
		public function fetchByListaId($lista_id, $order = null) 
		{
			if(is_numeric($lista_id)) {
				return parent::fetchRow(array("lista_id = '".$lista_id."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("lista_id", "int"));
		}
		
		public function fetchByCandidatoIdSimbolo($candidato_id, $simbolo, $order = null) 
		{
			if(is_numeric($candidato_id)) {
				$select = $this->getDbTable()->select()
					->from(array('l' => Application_Model_DbTable_Liste::_table_name), array('c.id','c.posizione','c.voti','c.percentuale','c.seggi'))
					->joinInner(array('c'	=> 	Application_Model_DbTable_CandidatiHasListe::_table_name),'c.lista_id = l.lista_id', array())
					->where('c.candidato_id = "' . $candidato_id .'" AND l.simbolo = "'.$simbolo.'"')->setIntegrityCheck(false);
				
				return parent::fetchRow($select, $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("candidato_id", "int"));
		}
	}
	
	
