<?php

	class Application_Model_Mapper_Candidati extends Dyrecta_Mapper_Base
	{
		public function __construct()
		{
			parent::setDbTable("Application_Model_DbTable_Candidati");
		}
		
		public function fetchAll($order = null, $count = null, $offset = null) 
		{
			return parent::fetchAll(null, $order, $count, $offset);
		}
		
		public function fetchByNome($nome, $order = null) 
		{
			if(is_string($nome)) {
				return parent::fetchRow(array("nome = '".$nome."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("nome", "string"));
		}
		
		public function fetchByCognome($cognome, $order = null) 
		{
			if(is_string($cognome)) {
				return parent::fetchRow(array("cognome = '".$cognome."'"), $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("cognome", "string"));
		}
	
		public function fetchByEnteIdDataNascita($ente_id, $data, $order = null) {
			if(is_numeric($ente_id)) {
				$select = $this->getDbTable()->select()
					->from(array('c' => Application_Model_DbTable_Candidati::_table_name), array('c.candidato_id'))
					->joinInner(array('e'	=> 	Application_Model_DbTable_EntiHasCandidati::_table_name),'c.candidato_id = e.candidato_id', array())
					->where('e.ente_id = "' . $ente_id .'" AND c.data_nascita = "'.$data.'"')->setIntegrityCheck(false);
					//->where('e.ente_id = "' . $ente_id .'" AND c.nome = "'.$nome.'" AND c.cognome = "'.$cognome.'"')->setIntegrityCheck(false);

				return parent::fetchRow($select, $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("ente_id", "int"));
		}
			
		public function fetchByEnteIdNomeCognome($ente_id, $nome, $cognome, $order = null) {
			if(is_numeric($ente_id)) {
				$select = $this->getDbTable()->select()
					->from(array('c' => Application_Model_DbTable_Candidati::_table_name), array('c.candidato_id'))
					->joinInner(array('e'	=> 	Application_Model_DbTable_EntiHasCandidati::_table_name),'c.candidato_id = e.candidato_id', array())
					->where('e.ente_id = "' . $ente_id .'" AND MD5(c.nome) = "'.$nome.'" AND MD5(c.cognome) = "'.$cognome.'"')->setIntegrityCheck(false);
					//->where('e.ente_id = "' . $ente_id .'" AND c.nome = "'.$nome.'" AND c.cognome = "'.$cognome.'"')->setIntegrityCheck(false);

				return parent::fetchRow($select, $order);
			}
			throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("ente_id", "int"));
		}
	}
	
	