<?php

	class Application_Model_Regioni extends Dyrecta_Model_Base
	{
		public function __construct($options = null) 
		{
			$this->_mapper = new Application_Model_Mapper_Regioni();
			parent::__construct($options);
		}
		
		public function getRegioniEntiComuniAttivi($order = null, $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
		{
			$values = $this->_mapper->fetchRegioniEntiComuniAttivi($order, $count, $offset);
			if(null === $values) return;
			else {
				return $this->ReturnValue($values, $dataType);
			}
		}

		public function getRegioneComuniByEnteId($ente_id, $order = null)
		{
			$values = $this->_mapper->fetchRegioneComuniByEnteId($ente_id, $order);
			if($values === null) return;
			else {
				return $this->ReturnValue($values);
			}
		}
		
		public function getProvinciaComuniByEnteId($ente_id, $order = null)
		{
			$values = $this->_mapper->fetchProvinciaComuniByEnteId($ente_id, $order);
			if($values === null) return;
			else {
				return $this->ReturnValue($values);
			}
		}
		
		public function getRegioneProvinciaByEnteId($ente_id, $order = null)
		{
			$values = $this->_mapper->fetchRegioneProvinciaByEnteId($ente_id, $order);
			if($values === null) return;
			else {
				return $this->ReturnValue($values);
			}
		}
		
	}
	
	