<?php

class Application_Model_Liste extends Dyrecta_Model_Base
{
	public function __construct($options = null) 
	{
		$this->_mapper = new Application_Model_Mapper_Liste();
		parent::__construct($options);
	}
	
	public function setAcronimo()
	{
    	$arrListe = $this->_mapper->fetchAll();

    	foreach ($arrListe as $lista) {
    		if(preg_match('/ /', $lista['descrizione']))
    		{
    			$lista['descrizione'] = preg_replace('/^IL /', '', $lista['descrizione']);
    			$lista['descrizione'] = preg_replace('/^DI PIETRO /', '', $lista['descrizione']);
    			$lista['descrizione'] = preg_replace('/LISTA CIVICA /', '', $lista['descrizione']);
    			$lista['descrizione'] = preg_replace('/LISTA LOCALE /', '', $lista['descrizione']);
    			$lista['descrizione'] = preg_replace('/\'/', '', $lista['descrizione']);
    			
    			$split = preg_split('/ - /i', $lista['descrizione'], -1, PREG_SPLIT_OFFSET_CAPTURE);
    			$lista['descrizione'] = $split[0][0];
    			
    			$arrAcronimo = explode(' ', $lista['descrizione']);
    			$acronimo = '';
    			
    			foreach ($arrAcronimo as $serialize) {
    				$acronimo .= substr($serialize, 0, 1);
    			}
    		} else {
    			$acronimo = $lista['descrizione'];
    		}
    		
    		$arrLista = array();
    		
    		$arrLista['lista_id'] = (int)$lista['lista_id'];
    		$arrLista['acronimo'] = (string)($acronimo);
    		
    		$this->_mapper->updateByPrimaryKey($arrLista);

    	}		
	}
	
	public function updateAggiornamentiListeByPrimaryKey($params) 
	{
		$modCandidatiHasListe = new Application_Model_Mapper_CandidatiHasListe();
		return $modCandidatiHasListe->updateByPrimaryKey($params);
	}

}