<?php

class Application_Model_Eventi extends Dyrecta_Model_Base
{
	public function __construct($options = null) 
	{
		$this->_mapper = new Application_Model_Mapper_Eventi();
		parent::__construct($options);
	}

	public function getEventi()
	{
		echo "Sei sicuro di voler importare gli eventi del ". Dyrecta_Date::StringToSql($this->_configs->seas->data) ." ?\n";
		echo "Digita 'si' per continuare: ";
		$handle = fopen ("php://stdin","r");
		$line = fgets($handle);
		if(trim($line) != 'si'){
		    echo "\nImportazione annullata\n";
		    return;
		}
		echo "\n";
		echo "Importazione Eventi in corso...\n";
		
    	$this->getSeasEventi();	
    	
    	$arrEventi = $this->fetchAll();

    	$tipi = new Application_Model_TipiEventi();
    	$arrTipi = $tipi->fetchAll();
    		
    	foreach ($arrEventi as $evento) {
    		echo "\n" . $evento['descrizione'] . "\n";
    		
    		foreach ($arrTipi as $tipo) {
    			echo $tipo['tipo_evento_id'] . ": " . $tipo['nome'] . "\n";
    		}
    		
    		echo "Scegli il tipo di evento:\n";
    		
    		$handle = fopen ("php://stdin","r");
			$line = fgets($handle);
			if(is_numeric(trim($line))){
				echo "\nSelezionata opzione " . trim($line) . " per evento " . $evento['descrizione'] . "\n";
				$evento['tipo_evento_id'] = trim($line);
				$this->_mapper->insertOrUpdateIfExistByPrimaryKey($evento);
			}else{
		    	echo "\nImportazione annullata\n";
		    	return;
			}
    	}
    	
    	echo "Importazione Enti Partecipanti in corso...\n";
    	
    	$enti = new Application_Model_Enti();
    	
    	foreach ($arrEventi as $evento) {
    		$enti->getSeasEnti($evento['evento_id']);
    	}
        	
    	echo "Importazione Liste e Candidati in corso...\n";
    	
    	$candidati = new Application_Model_Candidati();
    	
    	foreach ($arrEventi as $evento) {
    		$candidati->getSeasListeCandidatiReferendum($evento['evento_id']);
    	}
    	
    	$aggiornamenti = new Application_Model_Aggiornamenti();
    	$aggiornamenti->getSeasComunali();
    	$aggiornamenti->getSeasProvinciali();
    	
    	echo "Importazione Completata\n";	
	}
	
	public function getSeasEventi()
	{
    	$request = '<?xml version="1.0" encoding="utf-8"?>
    		<seas_parametro>
    			<data-evento-elettorale-param>
    				<data>' . $this->_configs->seas->data . '</data>
    			</data-evento-elettorale-param>
    		</seas_parametro>';

    	$method = 'getEventiElettorali';
    	$seas = new Application_Model_Seas();
    	$xml = $seas->getSeas($request, $method);
    	
    	//Zend_Debug::dump($xml);
    	
	    foreach ($xml->{'elenco-eventi-elettorali-param'}->elezione as $evento) {

	    	$objEventi = new Application_Model_Common_Eventi();
	    	
    		foreach ($evento->tipoElezione as $elezione) {
    			$objEventi->evento_id = (int)$elezione->codice;
    			$objEventi->descrizione = (string)$elezione->descrizione;
    		}

    		$objEventi->data = Dyrecta_Date::StringToSql((string)$evento->data);
    		
    		$this->_mapper->insertOrUpdateIfExistByPrimaryKey($objEventi->toArray());
    	}
	}
	
	public function getByPrimaryKey($id)
	{
		if(is_int($id)) {
			return new Application_Model_Common_Eventi($this->_mapper->find($id));
		}
		throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("id", "int"));
	}

	public function fetchAll()
	{
		return $this->_mapper->fetchAll();
	}
	
	public function save($params)
	{
		if($params instanceof Application_Model_Common_Eventi) {
			$params = $params->toArray();
		}
		$objEventi = new Application_Model_Common_Eventi();
		$objEventi->validate($params);
		return $this->_mapper->saveByPrimaryKey($params);
	}

	public function delete($id) 
	{
		if(is_int($id)) {
			return $this->_mapper->deleteByPrimaryKey($id);
		} 
		throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("id", "int"));
	}
	
}

