<?php

class Application_Model_Enti extends Dyrecta_Model_Base
{
	public function __construct($options = null) 
	{
		$this->_mapper = new Application_Model_Mapper_Enti();
		parent::__construct($options);
	}
	
	public function getSeasEnti($evento_id)
	{
		$evento = new Application_Model_Mapper_Eventi();
		
		$arrEvento = $evento->find($evento_id);

		if (null !== $arrEvento)
			$tipo_evento_id = $arrEvento['tipo_evento_id'];
		else
			return;

        $request = '<?xml version="1.0" encoding="utf-8"?>
        	<seas_parametro>
        		<evento-elettorale-param>
        			<elezione-selezionata>
        				<tipoElezione>
        					<codice>'.$evento_id.'</codice>
        				</tipoElezione>
        				<data>' . $this->_configs->seas->data . '</data>
        			</elezione-selezionata>
        		</evento-elettorale-param>
        	</seas_parametro>';
    	
     	$method = 'getEntiPartecipanti';
    	$seas = new Application_Model_Seas();
    	$xml = $seas->getSeas($request, $method);
    	  
    	//Zend_Debug::dump($xml);
    	//die();
    	
    	if($xml !== null) {		
    		foreach($xml->{'enti-partecipanti'}->italia->zona as $enti)
    		{
    			// Zona
    			$objZona = new Application_Model_Common_Zone();
    			$modZona = new Application_Model_Mapper_Zone();
    			
    			$objZona->zona_id = (int)$enti->codice;
    			$objZona->nome = (string)$enti->nome;
    			
    			$modZona->insertOrUpdateIfExistByPrimaryKey($objZona->toArray());
    			
    			foreach($enti->regione as $regioni)
    			{
    				// Regione
    				$objRegione = new Application_Model_Common_Regioni();
					$modRegione = new Application_Model_Mapper_Regioni();
					
    				$objRegione->regione_id = (int)$regioni->codice;
    				$objRegione->nome = (string)$regioni->nome;
    				$objRegione->zona_id = (int)$objZona->zona_id;
    				
    				$modRegione->insertOrUpdateIfExistByPrimaryKey($objRegione->toArray());
    				
    				foreach($regioni->provincia as $province) {
    					// Provincia
    					
    					$objProvincia = new Application_Model_Common_Province();
    					$modProvincia = new Application_Model_Mapper_Province();
    					
    					$objProvincia->provincia_id = (int)$province->codice;
						$objProvincia->nome = (string)$province->nome;
						$objProvincia->regione_id = (int)$objRegione->regione_id;

    					$modProvincia->insertOrUpdateIfExistByPrimaryKey($objProvincia->toArray());
    					
    					if($tipo_evento_id == 1) {
    						foreach($province->comune as $comune) {
    							// Comune
    							$modComune = new Application_Model_Mapper_Comuni();
    							$arrComune = $modComune->fetchByNome(addslashes((string)$comune->nome));
    							
    							if (null === $arrComune)
    							{
    								$arrComune['nome'] = (string)$comune->nome;
    								$arrComune['comune_id'] = $modComune->insert($arrComune);
    							} 
    							
    							$modProvinceHasComuni = new Application_Model_Mapper_ProvinceHasComuni();
    							$arrProvinceHasComuni = array('comune_id' => $arrComune['comune_id'],
    														  'provincia_id' => (int)$province->codice,
    														  'codice' => (int)$comune->codice);
    							$modProvinceHasComuni->insert($arrProvinceHasComuni);
								
								// Ente Comune
								$objEnte = new Application_Model_Common_Enti();
								$modEnte = new Application_Model_Mapper_Enti();
								
								$objEnte->evento_id = (int)$evento_id;
								$objEnte->sezioni_parziali_candidato = 0;
								$objEnte->sezioni_parziali_consiglio = 0;
								$objEnte->sezioni_totali = 0;
								$objEnte->seggi_spettanti = 0;
								$objEnte->elettori = 0;
								$objEnte->votanti = 0;
								$objEnte->percentuale_votanti = '0,00';
								$objEnte->schede_bianche = 0;
								$objEnte->schede_nulle = 0;
								$objEnte->schede_contestate = 0;
								if ($arrComune['nome'] == 'MILANO' OR 
									$arrComune['nome'] == 'NAPOLI' OR 
									$arrComune['nome'] == 'CAGLIARI' OR 
									$arrComune['nome'] == 'MODUGNO' OR 
									$arrComune['nome'] == 'COSENZA' OR 
									$arrComune['nome'] == 'CROTONE' OR 
									$arrComune['nome'] == 'NARDO\'')
									$objEnte->attivo = 1;
								else
									$objEnte->attivo = 0;
									
								$ente_id = $modEnte->insert($objEnte->toArray());
								
								$modEntiHasComuni = new Application_Model_Mapper_EntiHasComuni();
    							$arrEntiHasComuni = array('ente_id' => $ente_id,
    													  'comune_id' => $arrComune['comune_id']);
    							$modEntiHasComuni->insert($arrEntiHasComuni);								
								
    						}
    					}elseif($tipo_evento_id == 2) {
    						// Ente Comune
							$objEnte = new Application_Model_Common_Enti();
							$modEnte = new Application_Model_Mapper_Enti();
								
							$objEnte->evento_id = (int)$evento_id;
							$objEnte->sezioni_parziali_candidato = 0;
							$objEnte->sezioni_parziali_consiglio = 0;
							$objEnte->sezioni_totali = 0;
							$objEnte->seggi_spettanti = 0;
							$objEnte->elettori = 0;
							$objEnte->votanti = 0;
							$objEnte->percentuale_votanti = '0,00';
							$objEnte->schede_bianche = 0;
							$objEnte->schede_nulle = 0;
							$objEnte->schede_contestate = 0;
							$objEnte->attivo = 1;
							
							$ente_id = $modEnte->insert($objEnte->toArray());
								
							$modEntiHasProvince = new Application_Model_Mapper_EntiHasProvince();
    						$arrEntiHasProvince = array('ente_id' => $ente_id,
    													'provincia_id' => (int)$province->codice);
    						$modEntiHasProvince->insert($arrEntiHasProvince);
    					}else {
    						return;
    					}
    				}
    			}
    		}
    	}
	}
	
	public function getEntiProvinceAttivi($order = 'p.nome', $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchEntiProvinceAttivi($this->_configs->seas->data, $order, $count, $offset);
		
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getEntiComuniAttivi($order = 'c.nome', $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchEntiComuniAttivi($this->_configs->seas->data, $order, $count, $offset);
		
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiAggiornamentoEnteProvinceByEnteId($ente_id, $order = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		
		$values = $this->_mapper->fetchDatiAggiornamentoEnteProvinceByEnteId($ente_id, $order);
		
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiAggiornamentoEnteComuneByEnteId($ente_id, $order = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchDatiAggiornamentoEnteComuneByEnteId($ente_id, $order);
		
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}

	public function fetchDatiAggiornamentoCandidatiByEnteId($ente_id, $order = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY) {
		$values = $this->_mapper->fetchDatiAggiornamentoCandidatiByEnteId($ente_id, "posizione desc");
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiAggiornamentoListeByCandidatoId($candidato_id, $order = null, $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchDatiAggiornamentoListeByCandidatoId($candidato_id, $order,  "posizione desc");
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiAggiornamentoEntiAttiviProvincia($order = null, $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchDatiAggiornamentoEntiAttiviProvincia($order, $count, $offset);
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiAggiornamentoEntiAttiviComuni($order = null, $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchDatiAggiornamentoEntiAttiviComuni($order, $count, $offset);
		if(null === $values) return;
		else {
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiRiepilogoEntiAttiviProvincia($order = null, $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchDatiAggiornamentoEntiAttiviProvincia($order, $count, $offset);
		if(null === $values) return;
		else {
			for ($i = 0; $i < count($values); $i++) {
				$values[$i]['candidati'] = $this->_mapper->fetchCandidati($values[$i]['ente_id']);
			}

			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getDatiRiepilogoEntiAttiviComuni($order = null, $count = null, $offset = null, $dataType = Dyrecta_DATATYPE::TYPE_ARRAY)
	{
		$values = $this->_mapper->fetchDatiAggiornamentoEntiAttiviComuni($order, $count, $offset);
		if(null === $values) return;
		else {
			for ($i = 0; $i < count($values); $i++) {
				$values[$i]['candidati'] = $this->_mapper->fetchCandidati($values[$i]['ente_id']);
			}
			
			return $this->ReturnValue($values, $dataType);
		}
	}
	
	public function getByPrimaryKey($id)
	{
		if(is_int($id)) {
			return new Application_Model_Common_Enti($this->_mapper->find($id));
		}
		throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("id", "int"));
	}
	
	public function updateByPrimaryKey($params)
	{
		return $this->_mapper->updateByPrimaryKey($params);
	}
	
	public function save($params)
	{
		if($params instanceof Application_Model_Common_Enti) {
			$params = $params->toArray();
		}
		$objEventi = new Application_Model_Common_Enti();
		$objEventi->validate($params);
		return $this->_mapper->saveByPrimaryKey($params);
	}
	
	public function delete($id) 
	{
		if(is_int($id)) {
			return $this->_mapper->deleteByPrimaryKey($id);
		} 
		throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("id", "int"));
	}
	
}

