<?php

	class Application_Model_DbTable_Eventi extends Dyrecta_Db_Table_Abstract
	{
		const _table_name = "eventi";
		
		protected $_name = self::_table_name;
		protected $_id = "evento_id";
		
		protected $_dependentTables = array('Application_Model_Dbtable_EventiHasCandidati',
			'Application_Model_Dbtable_Enti');
 		
		protected $_referenceMap    = array(
        	'TipoEvento' => array(
	            'columns'           => array('tipo_evento_id'),
	            'refTableClass'     => 'Application_Model_Dbtable_TipiEventi',
	            'refColumns'        => array('tipo_evento_id'),
				'onDelete'			=> self::CASCADE,
				'onUpdate'			=> self::RESTRICT
        	)
    	);    	
    	
		public function getID()
		{
			return $this->_id;
		}
	}
	
