<?php

	class Application_Model_DbTable_Enti extends Dyrecta_Db_Table_Abstract
	{
		const _table_name = "enti";
		
		protected $_name = self::_table_name;
		protected $_id = "ente_id";
		
		protected $_dependentTables = array('Application_Model_Dbtable_EntiHasComuni',
			'Application_Model_Dbtable_EntiHasProvince',
			'Application_Model_Dbtable_TipiEventi',
			'Application_Model_Dbtable_EntiHasCandidati');  	

		protected $_referenceMap    = array(
        	'Evento' => array(
	            'columns'           => array('evento_id'),
	            'refTableClass'     => 'Application_Model_Dbtable_Eventi',
	            'refColumns'        => array('evento_id'),
				'onDelete'			=> self::CASCADE,
				'onUpdate'			=> self::RESTRICT
        	)  	
    	); 
    	
		public function getID()
		{
			return $this->_id;
		}
	}
	
