<?php

class Application_Model_Candidati extends Dyrecta_Model_Base
{
	public function __construct($options = null) 
	{
		$this->_mapper = new Application_Model_Mapper_Candidati();
		parent::__construct($options);
	}

	public function getSeasListeCandidatiReferendum($evento_id)
	{
		$evento = new Application_Model_Mapper_Eventi();
		$arrEvento = $evento->find($evento_id);
		
		if (null !== $arrEvento)
			$tipo_evento_id = $arrEvento['tipo_evento_id'];
		else
			return;

        $request = '<?xml version="1.0" encoding="utf-8"?>
        	<seas_parametro>
        		<evento-elettorale-param>
        			<elezione-selezionata>
        				<tipoElezione>
        					<codice>'.$evento_id.'</codice>
        				</tipoElezione>
        				<data>' . $this->_configs->seas->data . '</data>
        			</elezione-selezionata>
        		</evento-elettorale-param>
        	</seas_parametro>';
    	
    	$method = 'getListeCandidatiReferendum';
    	$seas = new Application_Model_Seas();
    	$xml = $seas->getSeas($request, $method);
    	
    	//Zend_Debug::dump($xml);
    	
    	if($xml !== null) {			
    		foreach($xml->{'enti-partecipanti'}->italia->zona as $enti)
    		{
    			// Zona
    			//echo (int)$enti->codice . '<br />';
    			//echo (string)$enti->nome . '<br />';
    			
    			foreach($enti->regione as $regioni)
    			{
    				// Regione
    				//echo (int)$regioni->codice . '<br />';
    				//echo (string)$regioni->nome . '<br />';
    				
    				foreach($regioni->provincia as $province) {
    					// Provincia
    					//echo (int)$province->codice . '<br />';
						//echo (string)$province->nome . '<br />';

    					if($tipo_evento_id == 1) {
    						foreach($province->comune as $comune) {
    							// Comune
    							//echo (int)$comune->codice . '<br />';
    							//echo (string)$comune->nome . '<br />';
    							
    							foreach ($comune->candidato as $candidato) {
    								// Candidato
    								$modProvinceHasComuni = new Application_Model_Mapper_ProvinceHasComuni();
    								$arrProvinceHasComuni = $modProvinceHasComuni->fetchByCodiceProvincia_id((int)$comune->codice, (int)$province->codice);
    								
    								$modEntiHasComuni = new Application_Model_Mapper_EntiHasComuni();
    								$ente = $modEntiHasComuni->fetchEnte((int)$arrProvinceHasComuni['comune_id']);
  								
    								$modCandidati = new Application_Model_Mapper_Candidati();
    								$objCandidati = new Application_Model_Common_Candidati();
    								
    								$objCandidati->cognome =  (string)$candidato->cognome;
    								$objCandidati->nome = (string)$candidato->nome;
    								$objCandidati->data_nascita = Dyrecta_Date::StringToSql((string)$candidato->{'data-nascita'});
    								$objCandidati->luogo_nascita =  (string)$candidato->{'luogo-nascita'};

    								$candidato_id = $modCandidati->insert($objCandidati->toArray());
    								
    								$modEntiHasCandidati = new Application_Model_Mapper_EntiHasCandidati();
    								$objEntiHasCandidati = new Application_Model_Common_EntiHasCandidati();
    								
    								$objEntiHasCandidati->ente_id = (int)$ente['ente_id'];
    								$objEntiHasCandidati->candidato_id = (int)$candidato_id;
    								$objEntiHasCandidati->posizione = (int)$candidato->posizione;
    								$objEntiHasCandidati->voti = 0;
    								$objEntiHasCandidati->percentuale = '0,00';
    								//$objEntiHasCandidati->eletto = null;
    								
    								$modEntiHasCandidati->insert($objEntiHasCandidati->toArray());
    								
    								foreach ($candidato->lista as $lista) {
    									$modListe = new Application_Model_Mapper_Liste();
    									$objListe = new Application_Model_Common_Liste();
    									
    									$objListe->descrizione = (string)$lista->descrizione;
    									$objListe->simbolo = (string)$lista->simbolo;
    									
    									$lista_id = $modListe->insert($objListe->toArray());
    									
    									$modCandidatiHasListe = new Application_Model_Mapper_CandidatiHasListe();
    									$objCandidatiHasListe = new Application_Model_Common_CandidatiHasListe();
    									
    									$objCandidatiHasListe->candidato_id = (int)$candidato_id;
    									$objCandidatiHasListe->lista_id = (int)$lista_id;
    									$objCandidatiHasListe->ccp = (int)$lista->ccp;
    									$objCandidatiHasListe->posizione = (int)$lista->posizione;
    									$objCandidatiHasListe->voti = 0;
    									$objCandidatiHasListe->percentuale = '0,00';
    									$objCandidatiHasListe->seggi = 0;
    									
    									$modCandidatiHasListe->insert($objCandidatiHasListe->toArray());
    									
    								}
    							}
    							
    						}
    					} elseif($tipo_evento_id == 2) {
    						
    						foreach ($province->candidato as $candidato) {
								// Candidato    								
    								$modEntiHasProvince = new Application_Model_Mapper_EntiHasProvince();
    								$ente = $modEntiHasProvince->fetchByProvinciaId((int)$province->codice);
  								
    								$modCandidati = new Application_Model_Mapper_Candidati();
    								$objCandidati = new Application_Model_Common_Candidati();
    								
    								$objCandidati->cognome =  (string)$candidato->cognome;
    								$objCandidati->nome = (string)$candidato->nome;
    								$objCandidati->data_nascita = Dyrecta_Date::StringToSql((string)$candidato->{'data-nascita'});
    								$objCandidati->luogo_nascita =  (string)$candidato->{'luogo-nascita'};

    								$candidato_id = $modCandidati->insert($objCandidati->toArray());
    								
    								$modEntiHasCandidati = new Application_Model_Mapper_EntiHasCandidati();
    								$objEntiHasCandidati = new Application_Model_Common_EntiHasCandidati();
    								
    								$objEntiHasCandidati->ente_id = (int)$ente['ente_id'];
    								$objEntiHasCandidati->candidato_id = (int)$candidato_id;
    								$objEntiHasCandidati->posizione = (int)$candidato->posizione;
    								$objEntiHasCandidati->voti = 0;
    								$objEntiHasCandidati->percentuale = '0,00';
    								//$objEntiHasCandidati->eletto = null;
    								
    								$modEntiHasCandidati->insert($objEntiHasCandidati->toArray());
    								
    							foreach ($candidato->lista as $lista) {
    								$modListe = new Application_Model_Mapper_Liste();
    								$objListe = new Application_Model_Common_Liste();
    									
    								$objListe->descrizione = (string)$lista->descrizione;
    								$objListe->simbolo = (string)$lista->simbolo;
    									
    								$lista_id = $modListe->insert($objListe->toArray());
    									
    								$modCandidatiHasListe = new Application_Model_Mapper_CandidatiHasListe();
    								$objCandidatiHasListe = new Application_Model_Common_CandidatiHasListe();
    									
    								$objCandidatiHasListe->candidato_id = (int)$candidato_id;
    								$objCandidatiHasListe->lista_id = (int)$lista_id;
    								$objCandidatiHasListe->ccp = (int)$lista->ccp;
    								$objCandidatiHasListe->posizione = (int)$lista->posizione;
    								$objCandidatiHasListe->voti = 0;
    								$objCandidatiHasListe->percentuale = '0,00';
    								$objCandidatiHasListe->seggi = 0;
    									
    								$modCandidatiHasListe->insert($objCandidatiHasListe->toArray());
    							}
    						}

    					} else {
    						return;
    					}
    				}
    			}
    		}
    	}
	}
	
	public function setNomeCognome()
	{
	    $arrCandidati = $this->_mapper->fetchAll();

    	foreach ($arrCandidati as $candidato) {
    		
    		if(preg_match('/ /', $candidato['nome']))
    		{
    			$nome = explode(' ', $candidato['nome']);
    			$nome = $nome['0'];	
    		} else {
    			$nome = $candidato['nome'];
    		}
    		
    		$arrCandidato = array();
    		
    		$arrCandidato['candidato_id'] = (int)$candidato['candidato_id'];
    		$arrCandidato['nome_cognome'] = (string)($nome . ' ' . $candidato['cognome']);
    		
    		$this->_mapper->updateByPrimaryKey($arrCandidato);
    	}		
	}
	
	public function getByPrimaryKey($id)
	{
		if(is_int($id)) {
			return new Application_Model_Common_Enti($this->_mapper->find($id));
		}
		throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("id", "int"));
	}
	
	public function updateAggiornamentiCandidatiByPrimaryKey($params)
	{
		$mapCandidatiEntiHasCandidati = new Application_Model_Mapper_EntiHasCandidati();
		return $mapCandidatiEntiHasCandidati->updateByPrimaryKey($params);
	}
	
	public function save($params)
	{
		if($params instanceof Application_Model_Common_Enti) {
			$params = $params->toArray();
		}
		$objEventi = new Application_Model_Common_Enti();
		$objEventi->validate($params);
		return $this->_mapper->saveByPrimaryKey($params);
	}
	
	public function delete($id) 
	{
		if(is_int($id)) {
			return $this->_mapper->deleteByPrimaryKey($id);
		} 
		throw new Dyrecta_Exception("DYxPARAM_NOT_VALID", "", array("id", "int"));
	}
	
}

