<?php

class Application_Model_Aggiornamenti extends Dyrecta_Model_Base
{
	public function __construct($options = null) 
	{
		$this->_mapper = new Application_Model_Mapper_Enti();
		parent::__construct($options);
	}
	
	public function getSeasComunali() {
		$modEnti = new Application_Model_Mapper_Enti();
		$arrEnti = $modEnti->fetchSeasComunali($this->_configs->seas->data);
		
		foreach ($arrEnti as $ente) {
			$this->getSeasAggiornamentoEnte($ente['codice'], $ente['provincia_id'], $ente['evento_id'], $ente['data']);
		}

	} 
	
	private function getSeasAggiornamentoEnte($codice, $provincia_id, $evento_id) {
    	$request = '<?xml version="1.0" encoding="utf-8"?>
			    	<seas_parametro>
						<aggiornamento-ente-param>
							<ente-selezionato>
								<codComune>'.$codice.'</codComune>
								<codProvincia>'.$provincia_id.'</codProvincia>
							</ente-selezionato>
							<elezione-selezionata>
								<tipoElezione>
									<codice>'.$evento_id.'</codice>
									<descrizione/>
								</tipoElezione>
								<data>' . $this->_configs->seas->data . '</data>
							</elezione-selezionata>
							<tipo-aggiornamento-selezionato>
								<codice>M</codice>
							</tipo-aggiornamento-selezionato>
						</aggiornamento-ente-param>
					</seas_parametro>';

    	$method = 'getAggiornamentoEnte';
    	$seas = new Application_Model_Seas();
    	$xml = $seas->getSeas($request, $method);

    	//Zend_Debug::dump($xml);

       	if($xml !== null) {
       		if($xml->codice == '300')
       			return;
       		
       		$objEnti = new Application_Model_Common_Enti();
       		$objEnti->dataOraAggiornamento = Dyrecta_Date::StringToSql((string)$xml->dataOraAggiornamento);
       		$objEnti->dataOraAggiornamentoManuale = Dyrecta_Date::StringToSql((string)$xml->dataOraAggiornamento);
       		$objEnti->evento_id = $evento_id;
       		
       		foreach ($xml->scrutini->italia->zona->regione->provincia as $provincia)
       		{
       			//echo 'provincia ' . $provincia->nome . '<br />';
       			//echo 'codice ' . $provincia->codice . '<br />';
       			
	       		foreach ($provincia->comune as $comune)
	       		{
	       			//echo 'comune ' . $comune->nome . '<br />';
       				//echo 'codice ' . $comune->codice . '<br />';
       				
		    		foreach($comune->dati as $dati)
		    		{
						$modProvinceHasComuni = new Application_Model_Mapper_ProvinceHasComuni();
						$arrProvinceHasComuni = $modProvinceHasComuni->fetchByCodiceProvincia_id((int)$comune->codice, (int)$provincia->codice);
		    								
						$modEntiHasComuni = new Application_Model_Mapper_EntiHasComuni();
						$ente = $modEntiHasComuni->fetchEnte((int)$arrProvinceHasComuni['comune_id']);
						$objEnti->ente_id = $ente['ente_id'];
						
						$modEnti = new Application_Model_Mapper_Enti();

						if (null !== $modEnti->fetchByDataOraAggiornamento((int)$objEnti->ente_id, (string)$objEnti->dataOraAggiornamento))
							return;

		    			$objEnti->sezioni_parziali_candidato = (int)$dati->{'sezioni-parziali-candidato'};
		    			$objEnti->sezioni_parziali_consiglio = (int)$dati->{'sezioni-parziali-consiglio'};
		    			$objEnti->sezioni_totali = (int)$dati->{'sezioni-totali'};
		    			$objEnti->seggi_spettanti = (int)$dati->{'seggi-spettanti'};
		    			$objEnti->elettori = (int)$dati->elettori;
		    			$objEnti->votanti = (int)$dati->votanti;
		    			$objEnti->percentuale_votanti = (string)$dati->{'percentuale-votanti'};
		    			$objEnti->schede_bianche = (int)$dati->{'schede-bianche'};
		    			$objEnti->schede_nulle = (int)$dati->{'schede-nulle'};
		    			$objEnti->schede_contestate = (int)$dati->{'schede-contestate'};
		    			$objEnti->attivo = 1;
		    			
		    			$modEnti->updateByPrimaryKey($objEnti->toArray());		
		    			
		    			foreach($dati->candidato as $candidato)
		    			{
		    				$modCandidati = new Application_Model_Mapper_Candidati();
		    				$arrCandidati = $modCandidati->fetchByEnteIdDataNascita($objEnti->ente_id, Dyrecta_Date::StringToSql((string)$candidato->{'data-nascita'}));
		    				
		    				$modEntiHasCandidati = new Application_Model_Mapper_EntiHasCandidati();
		    				$arrEntiHasCandidati = $modEntiHasCandidati->fetchByCandidatoIdEnteId((int)$arrCandidati['candidato_id'], $objEnti->ente_id);

		    				if (null !== $arrEntiHasCandidati) {
			    				$arrEntiHasCandidati['posizione'] = (int)$candidato->posizione;
			    				$arrEntiHasCandidati['voti'] = (int)$candidato->voti;
			    				$arrEntiHasCandidati['percentuale'] = (string)$candidato->percentuale;
			    				$arrEntiHasCandidati['eletto'] = (string)$candidato->eletto;
	
			    				$modEntiHasCandidati->updateByPrimaryKey($arrEntiHasCandidati);
		    				}
		    				
		    				foreach($candidato->lista as $lista) {
		    					$modCandidatiHasListe = new Application_Model_Mapper_CandidatiHasListe();
		    					$arrCandidatiHasListe = $modCandidatiHasListe->fetchByCandidatoIdSimbolo((int)$arrCandidati['candidato_id'], (string)$lista->simbolo);
		    					
		    					if (null !== $arrCandidatiHasListe) {
			    					$arrCandidatiHasListe['posizione'] = (int)$lista->posizione;
			    					$arrCandidatiHasListe['voti'] = (int)$lista->voti;
			    					$arrCandidatiHasListe['percentuale'] = (string)$lista->percentuale;
			    					$arrCandidatiHasListe['seggi'] = (int)$lista->seggi;
			    					
			    					$modCandidatiHasListe->updateByPrimaryKey($arrCandidatiHasListe);
		    					}
		    				}
		    			}
		    		}
	       		}
       		}
    	}		
	}
	
	public function getSeasProvinciali() {
		$modEnti = new Application_Model_Mapper_Enti();
		$arrEnti = $modEnti->fetchSeasProvinciali($this->_configs->seas->data);
		
		foreach ($arrEnti as $ente) {
			$this->getSeasAggiornamentoLivelloRiepilogo($ente['provincia_id'], $ente['evento_id'], $ente['data']);
		}

	}
	
	private function getSeasAggiornamentoLivelloRiepilogo($provincia_id, $evento_id, $data) {
		$request = '<?xml version="1.0" encoding="utf-8"?>
			<seas_parametro>
				<aggiornamento-livello-riepilogo-param>
					<ente-riepilogo-selezionato>
						<codProvincia>'.$provincia_id.'</codProvincia>
					</ente-riepilogo-selezionato>
					<livello-riepilogo-per-elezione-selezionato>
						<livelloRiepilogo>
							<codice>P</codice>
						</livelloRiepilogo>
								<elezione-selezionata>
									<tipoElezione>
										<codice>'.$evento_id.'</codice>
										<descrizione/>
									</tipoElezione>
									<data>'.Dyrecta_Date::SqlToString($data).'</data>
								</elezione-selezionata>
								<tipoAggiornamento>
									<codice>M</codice>
								</tipoAggiornamento>
							</livello-riepilogo-per-elezione-selezionato>
						</aggiornamento-livello-riepilogo-param>
					</seas_parametro>';
		
		$method = 'getAggiornamentoLivelloRiepilogo';
    	$seas = new Application_Model_Seas();
    	$xml = $seas->getSeas($request, $method);
		
		if($xml !== null) {
       		if($xml->codice == '300')
       			return;
       			
			$objEnti = new Application_Model_Common_Enti();	
       		$objEnti->dataOraAggiornamento = Dyrecta_Date::StringToSql((string)$xml->dataOraAggiornamento);
       		$objEnti->dataOraAggiornamentoManuale = Dyrecta_Date::StringToSql((string)$xml->dataOraAggiornamento);
       		$objEnti->evento_id = $evento_id;
       		
       		foreach ($xml->scrutini->italia->zona->regione->provincia as $provincia)
       		{
       			//echo 'provincia ' . $provincia->nome . '<br />';
       			//echo 'codice ' . $provincia->codice . '<br />';
       				
	    		foreach($provincia->dati as $dati)
	    		{	
					$modEntiHasProvince = new Application_Model_Mapper_EntiHasProvince();
					$ente = $modEntiHasProvince->fetchEnte((int)$provincia->codice);
					$objEnti->ente_id = $ente['ente_id'];
					
					$modEnti = new Application_Model_Mapper_Enti();
					
					if (null !== $modEnti->fetchByDataOraAggiornamento((int)$objEnti->ente_id, (string)$objEnti->dataOraAggiornamento))
						return;

	    			$objEnti->sezioni_parziali_candidato = (int)$dati->{'sezioni-parziali-candidato'};
	    			$objEnti->sezioni_parziali_consiglio = (int)$dati->{'sezioni-parziali-consiglio'};
	    			$objEnti->sezioni_totali = (int)$dati->{'sezioni-totali'};
	    			$objEnti->seggi_spettanti = (int)$dati->{'seggi-spettanti'};
	    			$objEnti->elettori = (int)$dati->elettori;
	    			$objEnti->votanti = (int)$dati->votanti;
	    			$objEnti->percentuale_votanti = (string)$dati->{'percentuale-votanti'};
	    			$objEnti->schede_bianche = (int)$dati->{'schede-bianche'};
	    			$objEnti->schede_nulle = (int)$dati->{'schede-nulle'};
	    			$objEnti->schede_contestate = (int)$dati->{'schede-contestate'};
	    			$objEnti->attivo = 1;
	    			
	    			$modEnti->updateByPrimaryKey($objEnti->toArray());		
	    			
	    			foreach($dati->candidato as $candidato)
	    			{
	    				$modCandidati = new Application_Model_Mapper_Candidati();
	    				$arrCandidati = $modCandidati->fetchByEnteIdDataNascita($objEnti->ente_id, Dyrecta_Date::StringToSql((string)$candidato->{'data-nascita'}));
	    				
	    				$modEntiHasCandidati = new Application_Model_Mapper_EntiHasCandidati();

	    				$arrEntiHasCandidati = $modEntiHasCandidati->fetchByCandidatoIdEnteId((int)$arrCandidati['candidato_id'], $objEnti->ente_id);
	    				
	    				if (null !== $arrEntiHasCandidati) {
		    				$arrEntiHasCandidati['posizione'] = (int)$candidato->posizione;
		    				$arrEntiHasCandidati['voti'] = (int)$candidato->voti;
		    				$arrEntiHasCandidati['percentuale'] = (string)$candidato->percentuale;
		    				$arrEntiHasCandidati['eletto'] = (string)$candidato->eletto;
	    				
	    					$modEntiHasCandidati->updateByPrimaryKey($arrEntiHasCandidati);
	    				}
	    				
	    				foreach($candidato->lista as $lista) {
	    					$modCandidatiHasListe = new Application_Model_Mapper_CandidatiHasListe();
	    					$arrCandidatiHasListe = $modCandidatiHasListe->fetchByCandidatoIdSimbolo((int)$arrCandidati['candidato_id'], (string)$lista->simbolo);
	    					
	    					if (null !== $arrCandidatiHasListe) {
		    					$arrCandidatiHasListe['posizione'] = (int)$lista->posizione;
		    					$arrCandidatiHasListe['voti'] = (int)$lista->voti;
		    					$arrCandidatiHasListe['percentuale'] = (string)$lista->percentuale;
		    					$arrCandidatiHasListe['seggi'] = (int)$lista->seggi;
		    					
		    					$modCandidatiHasListe->updateByPrimaryKey($arrCandidatiHasListe);
	    					}
	    				}
	    			}
	    		}
       		}
    	}
	}

}

