<?php
	require_once 'Spreadsheet/Excel/Writer.php';
	
	class ExcelController extends Zend_Controller_Action
	{
		public function indexAction()
		{
			$modProvincialiAttive = new Application_Model_Enti();
			$this->view->entiProvince = $modProvincialiAttive->getEntiProvinceAttivi();
		}	
		
		public function provincialiAction()
		{
		$ente_id = $this->getRequest()->getParam("id");
			
			$modEnti = new Application_Model_Enti();
			$arrProvinciali = $modEnti->getDatiAggiornamentoEnteProvinceByEnteId((int)$ente_id);
			
			if($arrProvinciali !== null)
			{
				$workbook = new Spreadsheet_Excel_Writer();
				$workbook->send('Provinciale_'.$arrProvinciali["nome"].'.xls');
				$worksheet =& $workbook->addWorksheet('Provinciale_'.$arrProvinciali["nome"]);
				
				//Titolo Elezione
				$worksheet->write(0, 0, 'Provincia '.$arrProvinciali["nome"].' - '. 'SEZ. '.$arrProvinciali["sezioni_parziali_candidato"].' / '.$arrProvinciali["sezioni_totali"]);
				
				//Testa tipi elezioni
				$worksheet->write(1, 1, 'CANDIDATO');
				$worksheet->write(1, 2, 'LISTA');
				$worksheet->write(1, 3, '%');
				$worksheet->write(1, 4, 'VOTI');
				$worksheet->write(1, 5, '');
				$worksheet->write(1, 6, 'SIMBOLO');
				$worksheet->write(1, 7, 'GRANDE FOTO');
				$worksheet->write(1, 8, 'PICCOLA FOTO');
				
				//Dati
				$i = 2;
				$arrCandidati = $modEnti->fetchDatiAggiornamentoCandidatiByEnteId((int)$arrProvinciali["ente_id"]);
				foreach($arrCandidati as $candidato) {
					$worksheet->write($i, 1, $candidato["cognome"]);
					$worksheet->write($i, 2, '');
					$worksheet->write($i, 3, $candidato["percentuale"].'%');
					$worksheet->write($i, 4, (int)$candidato["voti"]);
					$worksheet->write($i, 5, '');
					$worksheet->write($i, 6, '');
					$worksheet->write($i, 7, '');
					$worksheet->write($i, 8, '');
					$i++;
				}
				
				$workbook->close();	
			}
			die();
		}
		
		public function comunaliAction()
		{
			$ente_id = $this->getRequest()->getParam("id");
			
			$modEnti = new Application_Model_Enti();
			$arrProvinciali = $modEnti->getDatiAggiornamentoEnteComuneByEnteId((int)$ente_id);
			
			if($arrProvinciali !== null)
			{
				$workbook = new Spreadsheet_Excel_Writer();
				$workbook->send('Comunale_'.$arrProvinciali["nome"].'.xls');
				$worksheet =& $workbook->addWorksheet('Comunale_'.$arrProvinciali["nome"]);
				
				//Titolo Elezione
				$worksheet->write(0, 0, 'Comune '.$arrProvinciali["nome"].' - '. 'SEZ. '.$arrProvinciali["sezioni_parziali_candidato"].' / '.$arrProvinciali["sezioni_totali"]);
				
				//Testa tipi elezioni
				$worksheet->write(1, 1, 'CANDIDATO');
				$worksheet->write(1, 2, 'LISTA');
				$worksheet->write(1, 3, '%');
				$worksheet->write(1, 4, 'VOTI');
				$worksheet->write(1, 5, '');
				$worksheet->write(1, 6, 'SIMBOLO');
				$worksheet->write(1, 7, 'GRANDE FOTO');
				$worksheet->write(1, 8, 'PICCOLA FOTO');
				
				//Dati
				$i = 2;
				$arrCandidati = $modEnti->fetchDatiAggiornamentoCandidatiByEnteId((int)$arrProvinciali["ente_id"]);
				foreach($arrCandidati as $candidato) {
					$worksheet->write($i, 1, $candidato["cognome"]);
					$worksheet->write($i, 2, '');
					$worksheet->write($i, 3, $candidato["percentuale"].'%');
					$worksheet->write($i, 4, (int)$candidato["voti"]);
					$worksheet->write($i, 5, '');
					$worksheet->write($i, 6, '');
					$worksheet->write($i, 7, '');
					$worksheet->write($i, 8, '');
					$i++;
				}
				$workbook->close();	
			}	
			die();
		}
		
	}
