<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
	protected $_acl;
	
	protected function _initAutoload()
    {
        $moduleLoader = new Zend_Application_Module_Autoloader(
        	array(
            	'namespace' => '',
            	'basePath' => APPLICATION_PATH,
        		'resourceTypes' => array (
								'helper' 	=> array(
												'path'			=> 	'helpers/actions',
												'namespace' 	=> 	'Helper_Action'
        									))
				));

		//Zend_Controller_Action_HelperBroker::addHelper(new Helper_Action_Message());
		//$this->_acl = new Dyrecta_Acl();
		
		
		//$moduleLoader->addResourceTypes(array('dbtable' => array('namespace' => 'DbTable', 'path'	=> 'models/dbtables')));
		
        return $moduleLoader;
    }

	protected function _initActionHelpers()
	{
		//Zend_Controller_Action_HelperBroker::addHelper(new Helper_Action_Acl(null, array('acl' => $this->_acl)));
	}
  
protected function _initViewHelpers()
    {   
        $this->bootstrap('layout');
        $layout = $this->getResource('layout');
        
        $view = $layout->getView();
		$view->addHelperPath("Dyrecta/View/Helper", "Dyrecta_View_Helper");
		
        $view->doctype('XHTML1_STRICT');
        $view->headMeta()->appendHttpEquiv('Content-Type', 'text/html;charset=utf-8');
        $view->headTitle()->setSeparator(' - ');
        $view->headTitle('Dyrecta Zend CMS');
		
        
        //<!-- Global stylesheets -->
		$view->headLink()->appendStylesheet('/css/reset.css')
						 ->appendStylesheet('/css/common.css')
						 ->appendStylesheet('/css/form.css')
						 ->appendStylesheet('/css/standard.css');
        
		
		//$view->headLink()->appendStylesheet('/css/960.gs.css'); //Per un layout fisso
	    $view->headLink()->appendStylesheet('/css/960.gs.fluid.css'); //Per un layout fluido
	    
	    //<!-- Custom styles -->
	    $view->headLink()->appendStylesheet('/css/simple-lists.css')
						 ->appendStylesheet('/css/block-lists.css')
						 ->appendStylesheet('/css/planning.css')
						 ->appendStylesheet('/css/table.css')
						 ->appendStylesheet('/css/calendars.css')
						 ->appendStylesheet('/css/wizard.css')
						 ->appendStylesheet('/css/gallery.css');
		 
		//<!-- jQuery plugins Styles -->
		$view->headLink()->appendStylesheet('/css/jquery-ui-1.8.11.custom.css');
						 
	 	//<!-- Favicon -->
		$view->headLink(array('rel' => 'shortcut icon',
		 					  'type' => 'image/x-icon',
                              'href' => '/favicon.ico'))
	 		 ->headLink(array('rel' => 'icon',
		 	   				  'type' => 'image/png',
                              'href' => '/favicon-large.png'));

 		
 	  	
	   	//<!-- Generic libs -->
		$view->headScript()->appendFile('/js/html5.js') //<!-- this has to be loaded before anything else -->
						   ->appendFile('/js/jQuery/jquery-1.5.1.min.js')
						   ->appendFile('/js/old-browsers.js'); //<!-- remove if you do not need older browsers detection -->
		
	   

						  
		//<!-- Template libs -->
		$view->headScript()	->appendFile('/js/jquery.accessibleList.js')
						   	->appendFile('/js/searchField.js')
						   	->appendFile('/js/common.js')
						   	->appendFile('/js/standard.js')
	   						->appendFile('/js/jquery.tip.js')
	   						->appendFile('/js/jquery.hashchange.js')
	   						->appendFile('/js/jquery.contextMenu.js')
	   						->appendFile('/js/list.js');
		//<!-- jQuery Plugins -->
		$view->headScript()	->appendFile('/js/jQuery/plugins/jquery-ui-1.8.11.custom.min.js')	
							->appendFile('/js/jQuery/plugins/jclock/jquery.jclock.js')
							->appendFile('/js/jquery.timer-0.8.min.js');
							
			
    }
   	
}