<?php

class FieldCollection {
	private $counter;

	public function __construct() {
		$this->counter = 0;
	}

	public function add(&$field) {
		$name = $field->id;
		$this->$name = $field;
		$this->counter++;
	}

	public function remove(&$field) {
		$name = $field->id;
		unset($this->$name);
		$this->counter--;
	}
}

class Form {
	public $method = 'post';
	public $action = '';
	public $id = 'form_1';
	public $fields;
	//public $is_ajax = false;
	public $field_separator = "<br/>\n";
	//public $onsubmit = '';
	protected $enctype = '';
	public $pre_output = '';
	public $extra_output = '';


	const TABLE_FORMAT   = "<table%s>%s</table>\n";
	const CAPTION_FORMAT = "<caption>%s</caption>\n";
	const A_FORMAT       = '<a href="%s">%s</a>';
	const TR_FORMAT      = "<tr%s>\n%s\n</tr>\n";
	const TD_FORMAT      = "<td>%s</td>\n";
	const TH_FORMAT      = "<th>\n%s\n</th>\n";

	const FORM_FORMAT    = "<form id=\"%s\" method=\"%s\" action=\"%s\" class=\"form ui-corner-all\"%s>\n%s\n</form>\n";
	const FIELDSET_FORMAT= "<div id=\"%s\"><fieldset>%s</fieldset></div>\n";

	const ERROR_FORMAT   = "<div class=\"error\">\n%s\n</div>\n";
	const SERIE_FORMAT   = "<div class=\"%s\">\n%s\n</div>\n";
	const LEGEND_FORMAT  = '<legend class="legend">%s</legend>';



	public function __construct(){
		$this->fields = new FieldCollection();
	}

	// --------------------------------------------------------------------

	public function addFields(&$fields) {

		foreach ($fields as $field) {
			if (is_object($field) and isset($field->name)) {
				$this->fields->add($field);
			}
		}
	}

	// --------------------------------------------------------------------

	protected function orderFields(){
		//preparo le "serie" intese come liste di campi "contigui"
		foreach ($this->fields as $field_name => $field_ref){
			if (isset($field_ref->in)){
				if (isset($series_of_fields[$field_ref->in][0]) && $field_ref->label!="")
					$series_of_fields[$field_ref->in][0]->label .= '/'. $field_ref->label;
				$series_of_fields[$field_ref->in][] = $field_ref;
			} elseif(isset($field_ref->inline)) {
				$series_of_fields[$field_ref->inline][] = $field_ref;
			} else {
				$series_of_fields[$field_name][] = $field_ref;
			}
		}

		//preparo i "gruppi" intesi come field-groups del form
		$ordered_fields = array();
		foreach ($this->fields as $field_name => $field_ref) {
			if (!isset($field_ref->in) AND !isset($field_ref->inline)){
				if (isset($field_ref->type) AND $field_ref->type == 'hidden'){

					$field_ref->group = 'hiddens';
				}
				if (isset($field_ref->group)){
					$ordered_fields[$field_ref->group][$field_name] = $series_of_fields[$field_name];
				} else	{
					$ordered_fields["ungrouped"][$field_name] = $series_of_fields[$field_name];
				}
			}
		}
		unset($series_of_fields);
		
		
		//costruisco l'array principale da ciclare con tutti i gruppi > le serie > e i campi,
		$grps = array();
		$gr = array();
		foreach ($ordered_fields as $group=>$series_of_fields){
			unset($gr);
			
			$gr["group_name"] = $group;
			$sr = array();
			foreach ($series_of_fields as $series_name=>$serie_fields){
				unset($sr);
				$sr["series_name"] = $series_name;
				
				foreach ($serie_fields as $field_ref){
					$sr["fields"][] = $field_ref;
				}
				$gr["series"][] = $sr;
			}
			$grps[] = $gr;
		}
		return $grps;
	}

	// --------------------------------------------------------------------

	public function getForm() {
/*
		if (qs_value('ajax_form'))
		{
			$this->is_ajax = true;
		}
*/
		//in base agli attributi dei campi prepara un array raggruppando e ordinando i campi
		//logica: [gruppo(fieldset) [serie [campo...] ...] ...]
		
		//ordino i campi in base ai gruppi e serie di appartenenza
		$groups = $this->orderFields();
		
		//costruisco il corpo del form
		if (isset($groups)){
		
			//ciclo su tutti i gruppi di campi
			$output_groups = '';
			foreach ($groups as $group){
				
				$output_series = '';
				
				if ($group["group_name"] != "hiddens"){
				
					foreach ($group["series"] as $field_series){
					
						if(isset($field_series["fields"])){
							$output_fields = '';
							$errors = array();
							$first_field  = true;
							$required = false;
							$serie_has_inline = false;
							foreach ($field_series["fields"] as $field){
								// if (!is_a($field,'Field')) continue;
								if($field->error_string!=''){
									$errors[]= '<img src="/images/exclamation.png"> '.$field->error_string;
								}
								if(isset($field->rule) and $field->rule->required){
									$required = true;
								}

								if($first_field){
									$first_field=false;
									$output_fields .= $field->getLabel().'<div class="field">';
								} else {
									$output_fields .= ''; //'&nbsp;';
								}

								if (is_a($field, 'InputField')) {
									if ($field->type == 'file') {
										$this->enctype = ' enctype="multipart/form-data"';
									}
								}

								if (isset($field->inline)){
									$serie_has_inline = true;
									$output_fields .= '</div>'.$field->getInlineLabel().$field->getField();
								} else {
									$output_fields .= $field->getField();
								}

								$output_fields .= $field->getNote();
							}

							if (!$serie_has_inline){
								$output_fields .='</div>';
							}


						}

						if(count($errors)){
							$output_series .=	sprintf(self::ERROR_FORMAT, implode("<br/>\n",$errors));
						}

						$serie_class = (next($group["series"])===FALSE) ? "serie_last" : "serie";
						$output_series .=	sprintf(self::SERIE_FORMAT, $serie_class, $output_fields);

					}
					$output_group = $output_series;

					if ($group["group_name"] != "ungrouped"){
						$legend =  sprintf(self::LEGEND_FORMAT, $group["group_name"]);
						$output_group = sprintf(self::FIELDSET_FORMAT, $group["group_name"], $legend.$output_group);
					}
					$output_groups .= $output_group;

				//hiddens
				} else {
					foreach ($group["series"] as $field_series){
						foreach ($field_series["fields"] as $field){
							$output_groups .= $field->getField();
						}
					}
				}
			}
		}

/*
		$onsubmit = ($this->onsubmit!='') ? ' onsubmit="'.$this->onsubmit.'"' : '';

		if ($this->is_ajax){
			$url = qs_append('ts', time());
			$onsubmit = ' onsubmit="form_post(\''.$url.'\', \''.$this->id.'\'); return false;"';
			echo '<div id="div_'.$this->id.'">'.$this->pre_output.sprintf(self::FORM_FORMAT, $this->id, $this->method, $this->action, $this->enctype, $onsubmit, $output_groups).$this->extra_output.'</div>';
			die;
		}

		return '<div id="div_'.$this->id.'">'.$this->pre_output.sprintf(self::FORM_FORMAT, $this->id, $this->method, $this->action, $this->enctype, $onsubmit, $output_groups).'</div>'.$this->extra_output;
*/
		return '<div id="div_'.$this->id.'">'.$this->pre_output.sprintf(self::FORM_FORMAT, $this->id, $this->method, $this->action, $this->enctype, $output_groups).'</div>'.$this->extra_output;


	}
}


class NiceEditField extends Field
{
	public $rows = 10;
	public $css_class = 'wFixedLarge';
	public $readonly = false;
	public $disabled = false;

	public function getField()
	{

		$this->extra_output = "
			<script language=\"javascript\" type=\"text/javascript\">new nicEditor({
			iconsPath : '".REWRITE_BASE."libs/nicEdit/nicEditorIcons.gif',
			buttonList : ['bold','italic','underline','left','center','right','html','undo','redo','image']
			}).panelInstance('".$this->id."');
			</script>";

		$multiple = ($this->is_multiple) ? '[]' : '';
		$arr_index = ($this->arr_index!='') ? '['.$this->arr_index.']' : '';
		$arr_multi_index = (count($this->arr_multi_index)>0) ? '['.implode('][', $this->arr_multi_index).']' : '';
		$output = '<textarea name="%s" id="%s" class="%s" %s%s>%s</textarea>';
		$rows = ' rows="'.(string)$this->rows.'"';
		$disabled = ($this->disabled) ? ' disabled="disabled"' : '';

		return $this->pre_output.sprintf($output, $this->name.$multiple.$arr_index.$arr_multi_index, $this->id, $this->css_class, $rows, $disabled, $this->value).$this->extra_output;
	}
}




// --------------------------------------------------------------------

class Field {
	public $name;
	public $id;
	public $db_name;
	public $label;
	public $value;
	public $rule;
	public $error = false;
	public $error_string = '';
	public $note = '';
	public $css_class = '';
	public $style = '';
	public $extra_output = '';
	public $pre_output = '';
	public $is_multiple = false;
	public $arr_index = '';
	public $arr_multi_index = array();


	const LABEL_FORMAT   = '<label for="%s">%s</label>';
	const INLINE_LABEL_FORMAT   = '<div class="inline_label" id="label_%s">%s</div>';
	const CLEAR_FORMAT   = '<div class="clear"></div>';

	public function __construct($name, $label, $value='') {

		$id = $name;
		if (strpos($name,'[]')){
			$name = str_replace('[]','',$name);
			$id = $name;
			$this->is_multiple = true;
		}elseif (preg_match('/(\w+)\[(\w+)\]\[(\w+)\]/is', $name, $matches))
		{
			$name = $matches[1];
			$id = $matches[1].'_'.$matches[2].'_'.$matches[3];
			$this->arr_multi_index = array($matches[2],$matches[3]);
		}elseif (preg_match('/(\w+)\[(\w+)\]/is', $name, $matches))
		{
			$name = $matches[1];
			$id = $matches[1].'_'.$matches[2];
			$this->arr_index = $matches[2];
		}

		$this->name  = $name;
		$this->db_name = $name;
		$this->id    = $id;
		$this->label = $label;
		$this->value = $value;

	}

	public function getLabel(){
		if ($this->label!=''){

			$label = $this->label;
			if(isset($this->rule) and $this->rule->required){
				$label .= "*";
			}
			return sprintf(self::LABEL_FORMAT, $this->id, $label);
		}
	}

	public function getInlineLabel(){
		if ($this->label!=''){

			$label = $this->label;
			if(isset($this->rule) and $this->rule->required){
				$label .= "*";
			}
			return sprintf(self::INLINE_LABEL_FORMAT, $this->id, $label);
		}
	}

	public function getNote(){
		return ($this->note!='')? '&nbsp;'.$this->note : '';
	}

	public function setError($error){
		$this->error = true;
		$this->error_string = $error;
	}

	public function setPostValue($default='') {

	    if ($default!='') {
		$this->value = $default;
	    }
	    if (isset($_POST[$this->name])) {
		if (is_array($_POST[$this->name]))
		{
			if (count($this->arr_multi_index)>0) {
				$this->value = stripslashes($_POST[$this->name][$this->arr_multi_index[0]][$field->arr_multi_index[1]]);
			}
			elseif ($this->arr_index!='') {
				$this->value = $_POST[$this->name][$this->arr_index];
			} else	{
				$this->value = $_POST[$this->name];
			}
		} else {
			$this->value = stripslashes($_POST[$this->name]);
		}
	    }

	}

}

// --------------------------------------------------------------------

class InputField extends Field {
	public $type;
	public $checked = false;
	public $onchange = '';
	public $onkeydown = '';
	public $onkeyup = '';
	public $onclick = '';
	public $readonly = false;
	public $disabled = false;
	public $maxlength = '';
	public $autocomplete = '';


	public function __construct($type, $name, $label, $value='') {
		parent::__construct($name, $label, $value);
		$this->type = (string)$type;
		$this->css_class = ($type=='text'||$type=='file') ? 'wFixedMedium' : $this->type;
	}

	public function getField(){
		$checked  = ($this->checked AND in_array($this->type, array('radio','checkbox'))) ? ' checked="checked"' : '';
		$multiple = ($this->is_multiple) ? '[]' : '';
		$arr_index = ($this->arr_index!='') ? '['.$this->arr_index.']' : '';
		$arr_multi_index = (count($this->arr_multi_index)>0) ? '['.implode('][', $this->arr_multi_index).']' : '';
		$onchange = ($this->onchange!='') ? ' onchange="'.$this->onchange.'"' : '';
		$onkeyup = ($this->onkeyup!='') ? ' onkeyup="'.$this->onkeyup.'"' : '';
		$onkeydown = ($this->onkeydown!='') ? ' onkeydown="'.$this->onkeydown.'"' : '';
		$onclick = ($this->onclick!='') ? ' onclick="'.$this->onclick.'"' : '';
		$disabled = ($this->disabled) ? ' disabled="disabled"' : '';
		$readonly = ($this->readonly) ? ' readonly="readonly"' : '';
		$style = ($this->style) ? ' style="'.$this->style.'"' : '';
		$maxlength = ($this->maxlength!='') ? ' maxlength="'.$this->maxlength.'"' : '';
		$autocomplete = ($this->autocomplete) ? ' autocomplete="'.$this->autocomplete.'"' : '';
		$output = '<input type="%s" id="%s" name="%s" value="%s"  class="%s"%s%s%s%s%s%s%s%s%s%s/>';
		return $this->pre_output.sprintf($output, $this->type, $this->id, $this->name.$multiple.$arr_index.$arr_multi_index, htmlspecialchars($this->value), $this->css_class, $checked, $maxlength, $onclick, $onchange, $onkeydown, $onkeyup, $disabled, $readonly, $style, $autocomplete).$this->extra_output;
	}

}

// --------------------------------------------------------------------


class TextareaField extends Field {
	public $rows = 5;
	public $css_class = 'wFixedMedium';
	public $readonly = false;
	public $disabled = false;
	public $onchange = '';
	public $onkeydown = '';
	public $onkeyup = '';
	public $onclick = '';

	public function getField(){
		$multiple = ($this->is_multiple) ? '[]' : '';
		$arr_index = ($this->arr_index!='') ? '['.$this->arr_index.']' : '';
		$arr_multi_index = (count($this->arr_multi_index)>0) ? '['.implode('][', $this->arr_multi_index).']' : '';
		$onchange = ($this->onchange!='') ? ' onchange="'.$this->onchange.'"' : '';
		$onkeyup = ($this->onkeyup!='') ? ' onkeyup="'.$this->onkeyup.'"' : '';
		$onkeydown = ($this->onkeydown!='') ? ' onkeydown="'.$this->onkeydown.'"' : '';
		$onclick = ($this->onclick!='') ? ' onclick="'.$this->onclick.'"' : '';
		$output = '<textarea name="%s" id="%s" class="%s" %s%s%s>%s</textarea>';
		$rows = ' rows="'.(string)$this->rows.'"';
		$disabled = ($this->disabled) ? ' disabled="disabled"' : '';
		$style = ($this->style) ? ' style="'.$this->style.'"' : '';
		return $this->pre_output.sprintf($output
			,$this->name.$multiple.$arr_index.$arr_multi_index
			,$this->id
			,$this->css_class
			,$rows
			,$disabled
			,$style . $onkeydown . $onkeyup . $onchange . $onclick
			,$this->value
		).$this->extra_output;
	}


}

class FCKeditorField extends Field
{
	public function getField()
	{
		$multiple = ($this->is_multiple) ? '[]' : '';
		$arr_index = ($this->arr_index!='') ? '['.$this->arr_index.']' : '';
		$arr_multi_index = (count($this->arr_multi_index)>0) ? '['.implode('][', $this->arr_multi_index).']' : '';
		$field_name = $this->name.$multiple.$arr_index.$arr_multi_index;

		$sBasePath = REWRITE_BASE .'libs/fckeditor/' ;

		$oFCKeditor = new FCKeditor($field_name);
		$oFCKeditor->BasePath	= $sBasePath ;
		$oFCKeditor->Value		= $this->value;

		return $oFCKeditor->CreateHtml();
	}
}

class AutocompleterField extends InputField
{
	public $ajax_source     = '';
	public $hidden_field_id = '';
	public $record_id       = 'id';
	public $record_label    = 'label';
	public $oncomplete      = '';
	public $extra_param     = '';

	public function __construct($name, $label, $value='')
	{
		parent::__construct('text', $name, $label, $value);
	}
	public function getField()
	{
		$extraParams = '';
		if ($this->extra_param != ''){
			$extraParams = 'extraParams: {'.$this->extra_param.': function() { return $("#'.$this->extra_param.'").val();} },';
		}

		//$this->onchange = '$(\'#'. $this->hidden_field_id .'\').val(\'\');';
		$html = parent::getField();
		$html .= '<script type="text/javascript">
$(document).ready(



	function() {
	//autocomplete cliente
	$("#'. $this->id .'").autocomplete("'. $this->ajax_source .'", {
		max: 0,
		minChars: 2,
		dataType: "json",
		cacheLength: 1,
        '.$extraParams.'
		parse: function(data) {
					$(\'#'. $this->hidden_field_id .'\').val(\'\');
					return $.map(data, function(row) {
						return {
							data: row,
							value: row.'. $this->record_id .',
							result: row.'. $this->record_label .'
						}
					});
		},
		formatItem: function(item) {
			return item.'. $this->record_label .';
		}
	}).result(function(e, item) {
';

	$html .= '$("#'. $this->id .'").val(item.'. $this->record_label .');'."\n";

	if($this->hidden_field_id != "")
	{
		$html .= '$("#'. $this->hidden_field_id .'").val(item.'. $this->record_id .');'."\n";
	}

	if($this->oncomplete != "")
	{
		$html .= $this->oncomplete . "(item); \n";
	}


	$html .= '

	});
});
</script>';


		return $html;
	}
}



// --------------------------------------------------------------------


class SelectField extends Field {

	public $css_class = 'wFixedMedium';
	public $size;
	public $onchange='';
	public $onclick='';
	public $disabled = false;

	protected $options = array();

	public function getField(){
		$output = '<select name="%s" id="%s" class="%s"%s%s%s%s%s%s>%s</select>';
		$option = '<option label="%s" value="%s"%s>%s</option>';
		$onchange = ($this->onchange!='') ? ' onchange="'.$this->onchange.'"' : '';
		$onclick = ($this->onclick!='') ? ' onclick="'.$this->onclick.'"' : '';
		$disabled = ($this->disabled) ? ' disabled="disabled"' : '';
		$size = (isset($this->size)) ? ' size="'.$this->size.'"' : '';
		$select_multiple = ($this->is_multiple) ? ' multiple="multiple"' : '';
		$multiple = ($this->is_multiple) ? '[]' : '';
		$style = ($this->style) ? ' style="'.$this->style.'"' : '';
		$arr_index = ($this->arr_index!='') ? '['.$this->arr_index.']' : '';
		$arr_multi_index = (count($this->arr_multi_index)>0) ? '['.implode('][', $this->arr_multi_index).']' : '';

		$options = '';
		$values = (array)$this->value;
		foreach ($this->options as $value=>$description){

			$selected = (in_array((string)$value,$values)) ? ' selected="selected"' : '';
			$options .= sprintf($option, htmlspecialchars($description), $value, $selected, $description)."\n";
		}
		return $this->pre_output.sprintf($output, $this->name.$multiple.$arr_index.$arr_multi_index, $this->id, $this->css_class, $size, $select_multiple, $onclick, $onchange, $disabled, $style, $options).$this->extra_output;
	}

	public function setOption($value='', $description=''){
		$this->options[$value] = $description;
	}

	public function setOptions($options){
		$this->options += $options;
	}
/*	
	public function setOptgroup($options){
		$this->options += $options;
	}
*/
}



// --------------------------------------------------------------------


class RadioGroupField extends Field {

	public $disabled = false;
	public $separator = '&nbsp;&nbsp;';
	public $css_group_class = 'radiogroup';
	protected $options = array();

	public function getField(){
		$output = '<span class="%s">%s</span>';
		$options = '';
		$i = 1;
		foreach ($this->options as $value=>$description){
			$radio = new InputField('radio', $this->name,  $description, $value);
			$radio->checked = ($this->value == $value) ? true : false;
			$radio->disabled = $this->disabled;
			$radio->id = $this->name.$i;
			$options .= $radio->getField() . $description.$this->separator;
			$i++;
		}
		return $this->pre_output.sprintf($output, $this->css_group_class, $options).$this->extra_output;
	}

	public function setOption($value='', $description='')
	{
	      $this->options[$value] = $description;
	}

	public function setOptions($options)
	{
	      $this->options += $options;
	}
}


// --------------------------------------------------------------------


class CheckBoxGroupField extends Field {

	public $disabled  = false;
	public $separator = '';
	public $css_group_class = 'checkboxgroup';
	public $css_item_class = 'checkboxitem';
	public $inside_div_id = '';
	protected $options	= array();

	public function getField(){
		$item = '<div class="%s">%s</div>';
		$output = '<div class="%s"%s>%s%s%s</div>';
		$options = '';
		$values = (array)$this->value;
		//$i = 1;
		foreach ($this->options as $value=>$description){
			$checkbox = new InputField('checkbox', $this->name.'[]',  $description, $value);
			$checkbox->checked = (in_array($value, $values)) ?  true : false;
			$checkbox->disabled = $this->disabled;
			$checkbox->id = $this->name.'_'.(string)$value;//$i;
			$options .= sprintf($item, $this->css_item_class, $checkbox->getField(). $description).$this->separator;
			//$i++;
		}
		$inside_div_id = ($this->inside_div_id!='') ? ' id="'.$this->inside_div_id.'"' : '';
		return sprintf($output, $this->css_group_class, $inside_div_id, $this->pre_output, $options, self::CLEAR_FORMAT).$this->extra_output;
	}

	public function setOption($value='', $description=''){
		$this->options[$value] = $description;
	}

	public function setOptions($options){
		$this->options += $options;
	}
}


// --------------------------------------------------------------------


class FreeField extends Field {

	public function getField(){
		$output = '<div id="%s" class="%s">%s</div>';
		return $this->pre_output.sprintf($output,  $this->id, $this->css_class, $this->value).$this->extra_output;
	}

}




// --------------------------------------------------------------------

class Rule {
	public $required = false;
	public $type;
	public $value_min;
	public $value_max;
	public $lenght;
	public $lenght_min;
	public $lenght_max;

	protected $errors	= array(
		'required'	=> "  il campo \"%s\" è necessario.",
		'type_int'	=> "  il campo \"%s\" è deve contenere un numero intero.",
		'type_num'	=> "  il campo \"%s\" è deve contenere un numero.",
		'type_alpha'	=> "  il campo \"%s\" puo' contenere solo caratteri alfanumerici.",
		'type_email'	=> "  il campo \"%s\" deve contentere un indirizzo email valido.",
		'value'		=> "  il campo \"%s\" è deve essere compreso fra %s ed %s .",
		'length_min'	=> "  il campo \"%s\" è deve contentere almeno %s caratteri.",
		'length_max'	=> "  il campo \"%s\" è non puo' contenere piu' di %s caratteri.",
		'length'	=> "  il campo \"%s\" è deve contentere esattamente %s caratteri.",

		'upload_err_ini_size'	=> "  Il file \"%s\" eccede le dimensioni specificate nel parametro upload_max_filesize di php.ini",
		'upload_err_form_size'	=> "  Il file \"%s\" eccede le dimensioni specificate.",
		'upload_err_partial'	=> "  Il file \"%s\" &egrave; stato uplodato parzialmente",
		'upload_err_no_file'	=> "  Il file \"%s\" è necessario.",
		'upload_err_no_tmp_dir'	=> "  Mancanza della cartella temporanea.",
	);


	public function getError($name, $params=array()){
		return vsprintf($this->errors[$name], $params);
	}
}


// --------------------------------------------------------------------

class Validator {

	public $fields;
	public $error_array = array();
	public $error_string = '';

	// --------------------------------------------------------------------

	public function __construct(){
		$this->fields = new FieldCollection();
	}


	// --------------------------------------------------------------------

	public function setCustomError(&$field, $error)
	{
		$this->error_array[$field->id][] = $error;
		$field->setError($error);

		foreach ($this->error_array as $field_name=>$field_errors)
		{
			$field_error = implode("\n,",$field_errors);
			$this->error_string .= "--". $field_error."<br/>\n";
		}
	}

	// --------------------------------------------------------------------

	/**
	 * esegue la validazione in base a campi e regole impostate
	 */
	function isValid()
	{

		//non c'è  post o non ci sono regole, non c'è niente da validare
		if (count($_POST) == 0 OR count($this->fields) == 0)
		{
			return FALSE;
		}

		// ciclo sui campi e le regole per trovare errori
		foreach ($this->fields as $field_name=>$field)
		{
			if (!isset($field->rule)) continue;

			$rule  = $field->rule;
			$name  = $field->name;
			$id    = $field->id;
			$label = $field->label;
			$value = $field->value;
			$type  = (isset($field->type)? $field->type : '');


			//campi file errori di sistema
			if ($type=='file')
			{

				switch ($_FILES[$name]['error']) {
				case UPLOAD_ERR_INI_SIZE:
					$error = $rule->getError('upload_err_ini_size', array($label));
					$this->error_array[$id][] = $error;
					$field->setError($error);
					break;

				case UPLOAD_ERR_FORM_SIZE:
					$error = $rule->getError('upload_err_form_size', array($label));
					$this->error_array[$id][] = $error;
					$field->setError($error);
					break;

				case UPLOAD_ERR_PARTIAL:
					$error = $rule->getError('upload_err_partial', array($label));
					$this->error_array[$id][] = $error;
					$field->setError($error);
					break;

				case UPLOAD_ERR_NO_FILE:
					if ($rule->required)
					{
						$error = $rule->getError('upload_err_no_file', array($label));
						$this->error_array[$id][] = $error;
						$field->setError($error);

					}
				break;
				case UPLOAD_ERR_NO_TMP_DIR:
					$error = $rule->getError('upload_err_no_tmp_dir', array($label));
					$this->error_array['system'][] = $error;
					$field->setError($error);
					break;

				}





			//campi non file
			} else {

				if($field->arr_index != '') {
					$post_value = (isset($_POST[$name][$field->arr_index])? $_POST[$name][$field->arr_index] : '');
				} elseif(count($field->arr_multi_index)>0) {
					$post_value = (isset($_POST[$name][$field->arr_multi_index[0]][$field->arr_multi_index[1]])? $_POST[$name][$field->arr_multi_index[0]][$field->arr_multi_index[1]] : '');
				} else {
					$post_value = (isset($_POST[$name])? $_POST[$name] : '');
				}

				//required
				if ($rule->required) {
					if ($post_value == '') {
							$error = $rule->getError('required', array($label));
							$this->error_array[$id][] = $error;
							$field->setError($error);
					}
				}

				//type
				if (isset($post_value) && ($post_value != '') && isset($rule->type))
				{
					$result = false;
					switch($rule->type)
					{
						case "int":
							$result = preg_match("/^([0-9])+$/", $value);
							break;
						case "num":
							$result = is_numeric($value);
							break;
						case "alpha":
						  $result = preg_match("/^([-a-z0-9])+$/i", $value);
							break;
						case "email":
						  $result = preg_match("/@/i", $value);
							break;
						default:;
					}
					if (!$result){
						$error = $rule->getError('type_'.$rule->type, array($label));
						$this->error_array[$name][] = $error;
						$field->setError($error);
					}


					if (in_array($rule->type, array('int','num')) AND isset($rule->value_min, $rule->value_max)){

						if ($value > $rule->value_max  OR $value < $rule->value_min){
							$error = $rule->getError('value', array($label, $rule->value_min, $rule->value_max));
							$this->error_array[$name][] = $error;
							$field->setError($error);
						}
					}
				}

				if (isset($rule->lenght_max))
				{
					if (strlen($value) > $rule->lenght_max)
					{
						$error = $rule->getError('length_max', array($label, $rule->lenght_max));
						$this->error_array[$name][] = $error;
						$field->setError($error);
					}
				}
				if (isset($rule->lenght_min))
				{
					if (strlen($value) > $rule->lenght_min)
					{
						$error = $rule->getError('length_min', array($label, $rule->lenght_min));
						$this->error_array[$name][] = $error;
						$field->setError($error);
					}
				}
			}

		}
		$total_errors = count($this->error_array);

		// non ci sono errori?  allora la validazione è passata
		if ($total_errors == 0)
		{
			return TRUE;
		}

		// genero una stringa di errore
		foreach ($this->error_array as $field_name=>$field_errors)
		{
			$field_error = implode("\n,",$field_errors);
			$this->error_string .= "--". $field_error."<br/>\n";
		}

		return FALSE;
	}


	public function getError()
	{
		return $this->error_string;
	}

}

?>
