<?php

class DataColumnCollection {
	public function add(&$data_column) {
		$name = ($data_column->column_name);
		$this->$name = $data_column;
	}
	public function remove(&$data_column) {
		$name = ($data_column->column_name);
		unset($this->$name);
	}
}
class DataRowCollection {
	private $counter;
	public function __construct() {
		$this->counter = 0;
	}

	public function add(DataRow &$data_row) {
		$name = ($data_row->getRowName());
		$this->$name = $data_row;
		$this->counter++;
	}

	public function remove(DataRow &$data_row) {
		$name = ($data_row->getRowName());
		unset($this->$name);
		$this->counter--;
	}
}
class DataCellCollection {
	public function add(&$data_cell) {
		$name = ($data_cell->column_name);
		$this->$name = $data_cell;
	}
	public function remove(&$data_cell) {
		$name = ($data_cell->column_name);
		unset($this->$name);
	}
}
class DataTable {
	public $rows;
	public $columns;

	public function __construct() {
		$this->columns = new DataColumnCollection();
		$this->rows    = new DataRowCollection();
	}

	/**
	 * Creates a new DataRow with the same schema as the table.
	 *
	 * @return Object DataRow
	 */
	public function newRow() {
		$row = new DataRow();
		foreach ($this->columns as $k=>$column) {
			$value = '';
			if (!is_null($column->default_value)) {
				$value = $column->default_value;
			}
			$row->cells->add(new DataCell($column->column_name, $value));
			/*if ($column->style != '')
			{
				$column_name = $column->column_name;
				$row->cells->$column_name->style = $column->style;
			}*/
		}
		return $row;
	}

	public function hasForm(){
		foreach ($this->rows as $k=>$row)
		{
			if ($row->is_form) return true;
		}
		return false;
	}
}
class DataRow {
	public $row_name;
	public $css_class;
	public $cells;
	public $is_form = false;
	public function __construct() {
		$this->row_name  = md5(uniqid(rand(), true));
		$this->css_class = '';
		$this->cells     = new DataCellCollection();
	}

	public function getRowName() {
		return $this->row_name;
	}
}
class DataColumn {
	public $caption;
	public $column_name;
	public $default_value;
	public $data_type; // Non usato
	public $sortable;
	public $sortable_field;
	public $style;

	public function __construct($column_name, $caption=null) {
		$this->column_name = (string)$column_name;
		if ($caption) {
			$this->caption = (string)$caption;
		}
		$this->sortable = true;
		$this->sortable_field = $this->column_name;
	}
}
class DataCell {
	public $value;
	public $title;
	public $css_class;
	public $column_name;
	public $style;

	public function __construct($column_name, $val) {
		$this->column_name = (string)$column_name;
		$this->value = (string)$val;
		$this->title = '';
	}
}
?>