<?php

/**
 * dataset....
 *
 */

class DataSet {

  //impostazioni
	public $limit;
	public $sql;
	public $data;
	public $conn_id;
	public $total_items;
	public $max_visible_links = 6;
	public $remove_params = array();
	public $order_col;
	public $order_dir = 'ASC';

	protected $offset = 0;
	protected $sql_select;
	protected $sql_limit;
	protected $sql_orderby;
	protected $source_arr;

	//paginazione
	public $url;
	protected $current_page;
	protected $total_pages;

	protected $first_page;
	protected $last_page;
	protected $previous_page;
	protected $next_page;

	// --------------------------------------------------------------------

	public function __construct($sql,$conn_id=null, $sql_count=null){

		$this->conn_id = $conn_id;

		if (is_string($sql))
		{
			//query sql
			if (strpos($sql, ' ')!==false){
				$this->type = 'query';
				$this->sql  = $sql;
			//nome tabella
			} else {
				$this->type = 'table';
				$this->sql  = 'SELECT * FROM '.$sql;
			}

			if (isset($sql_count)){
				//eseguo query di count, ottengo numero righe
				$res = mysql_query($sql_count, $this->conn_id) or die(mysql_error());
				$row = mysql_fetch_row($res);
				$this->total_items = $row[0];
			} else {
				//eseguo query senza il limit, ottengo numero righe
				$res = mysql_query($this->sql, $this->conn_id) or die(mysql_error());
				$this->total_items = @mysql_num_rows($res);
			}
			//$sql_count = preg_replace('/SELECT(.*)FROM(.*)/is', "SELECT COUNT(*) FROM$2", $this->sql);


		//è già un array
		} elseif (is_array($sql)) {
			$this->type  = "array";
			$this->total_items = count($sql);
			$this->source_arr = $sql;
		}
	}

	// --------------------------------------------------------------------

	protected function initPagination(){

		if (!isset($this->url)){
		  $this->url = get_url();
		}


		$this->url = qs_append('pag', "pgnum", $this->url);
		$this->url = qs_remove('ajax_grid',$this->url);

		foreach ($this->remove_params as $param){
			$this->url = qs_remove($param,$this->url);
		}

		//proprietà necessarie alla navbar
		$this->total_items        = (int) max(0, $this->total_items);


		if (qs_value('/export_grid_\\d/') OR qs_value('/print_grid_\\d/'))
		{
			$this->limit = '';
		}
		if ($this->limit=='') {
			$this->limit = max(1,$this->total_items);
		} else {
			$this->limit = (int) max(1, $this->limit);
		}




		$this->total_pages        = (int) ceil($this->total_items / $this->limit);
		$this->current_page       = (int) min(max(1, qs_value('pag')), max(1, $this->total_pages));

		//condizioni (mostrare o meno un elemento della navbar)
	 	$this->first_page         = ($this->current_page == 1) ? FALSE : 1;
		$this->last_page          = ($this->current_page >= $this->total_pages) ? FALSE : $this->total_pages;
		$this->previous_page      = ($this->current_page > 1) ? $this->current_page - 1 : FALSE;
		$this->next_page          = ($this->current_page < $this->total_pages) ? $this->current_page + 1 : FALSE;

		//determino offset
		$this->offset = (int) ($this->current_page - 1) * $this->limit;
	}

	// --------------------------------------------------------------------

	protected function initOrderby(){
		if (qs_value("order_col")){
			$this->order_col = qs_value('order_col');
			$this->order_dir = qs_value('order_dir');
		}
	}


	// --------------------------------------------------------------------

	public function getData(){

		$data = array();

		//determino offset dalla querystring e preparo la paginazione
		$this->initPagination();

		//determino offset dalla querystring e preparo la paginazione
		$this->initOrderby();

		//costruisco subset di dati
		switch($this->type) {

			case "query":
			case "table":

				//orderby
				if ($this->order_col!=''){
					$this->sql_orderby = ' ORDER BY '.$this->order_col.' '.$this->order_dir;
				}
				//limit
				if ($this->limit!=''){
				  $this->sql_limit = ' LIMIT '.$this->limit.' OFFSET '.$this->offset;
				}
				$res = @mysql_query($this->sql.$this->sql_orderby.$this->sql_limit, $this->conn_id) or die(mysql_error());
				if ($res) {
					while ($r = mysql_fetch_assoc($res)){
						$data[] = $r;
					}
				}
			break;

			case "array":

				//orderby
				$column = array();
				$row = array();
				if ($this->order_col!=''){
					foreach ($this->source_arr as $key => $row){
						$column[$key] = $row[$this->order_col];
					}
					if ($this->order_dir=="DESC"){
						array_multisort($column, SORT_DESC, $this->source_arr);
					} else {
						array_multisort($column, SORT_ASC, $this->source_arr);
					}
				}
				//limit
				if ($this->limit!=''){
				  $data = array_slice($this->source_arr, $this->offset,  $this->limit);
				} else {
				  $data = $this->source_arr;
				}
			break;

		} //switch

		if(!$data){
			$data = array();
		}
		$this->data = $data;
		return $this->data;
	} //getData

	public function getLinks(){

		$links = '<div class="pagination" align="center">';
		if ($this->first_page){
			$links.= '<a href="'.str_replace('pgnum', 1, $this->url).'">prima pagina</a> ';
		}
		if ($this->previous_page){
			$links.= '<a href="'.str_replace('pgnum', $this->previous_page, $this->url).'">&lt;</a> ';
		}

		$gap = round($this->max_visible_links/2, 0);



		$start_page = ($this->current_page>$gap) ? $this->current_page - $gap : 1;
		$last_page = $start_page+$this->max_visible_links;

		for ($i = $start_page; $i <= $last_page; $i++){
			if ($i == $this->current_page){
				$links.= '<strong>'.$i.'</strong> ';
			} else {
				if ($i > $this->total_pages) break;
				$links.= '<a href="'.str_replace('pgnum', $i, $this->url).'">'.$i.'</a> ';
			}
		}

		if ($this->next_page){
			$links.= '<a href="'.str_replace('pgnum', $this->next_page, $this->url).'">&gt;</a> ';
		}
		if ($this->last_page){
			$links.= '<a href="'.str_replace('pgnum', $this->last_page, $this->url).'">ultima pagina</a>';
		}
		$links .= '</div>';
		return $links;
	}

}


?>