<?php
/**
 * implementazione di un "model"
 * classe generica per operare su un "record", leggere, scrivere, cancellare
 * è alla base del pattern "CRUD" il suo uso generico è
 *
 * $utente = new model('users');
 * $utente->load(12);
 * $utente->set('last_login',date('Y-m-d'));
 * $utente->save();
 *
 **/
class Model {
	public $debug        = false; //output query info
	public $error_string = ''; //
	public $table        = null;  //la tabella
	public $conn_id;  // la connessione
	public $loaded       = false;  //se i dati sono caricati o meno
	public $where        = '';   // la clausola where per caricare un record

	public $pk = array();  //array associativo con chiave/i primarie/valore

	public $fields = array(); //array dei campi (e rispettivi metatipi) della tabella
	public $data = array();   //array associativo con i "valori" del record corrente
	public $data_rel = array(); //array associativo con eventuali valori "joinati", non della tabella principale
	public $new_data = array(); //array con i "valori" dei campi modificati/nuovi nel record corrente
	public $action = 'idle';  //l'ultima operazione eseguita o in esecuzione
	public $has_many = array();


	public function query($sql)
	{
		if ($this->debug) echo "<pre>$sql\n\nConnection ID: ". $this->conn_id ."</pre><hr />";
		return mysql_query($sql, $this->conn_id);
	}


	// --------------------------------------------------------------------

	/**
	 * costrutture, richiede semplicemente il nome della tabella
	 **/
	public function __construct($table, $conn_id)	{
		$this->table = $table;
		$this->conn_id = $conn_id;

		//recupero la tipologia dei campi
		$res = $this->query("SELECT * FROM $table LIMIT 1");
		while ($field = mysql_fetch_field($res)) {
			$this->fields[$field->name] = $field;
			if ($field->primary_key) {
				$this->pk[$field->name] = "";
			}
		}

		//non c'è una chiave primaria, non posso usare un model
		if (count($this->pk)==0) {
			$this->show_error("model: nessuna chiave primaria sulla tabella ".$table);
			die();
		}
	}

	// --------------------------------------------------------------------

	public function has_many($field_name, $table_name, $table_pk)
	{
		$rel_arr["table_name"] = $table_name;
		$rel_arr["table_pk"] = $table_pk;
		$this->has_many[$field_name] = $rel_arr;
	}

	// --------------------------------------------------------------------

	/**
	 * comune funzione per l'output degli errori gravi
	 **/
	protected function show_error($error_arr) {
		echo '<p>'.implode('</p><p>', ( ! is_array($error_arr)) ? array($error_arr) : $error_arr).'</p>';
	}

	// --------------------------------------------------------------------

	/**
	 * carica il record passando un id (il valore di una chiave primaria),
	 * puo' eventualmente essere un array.
	 **/
	public function load($id)
	{
		if (!$this->loaded)
			$this->action = 'load';

		if (is_array($id))
		{
			if (sizeof($id) != sizeof($this->pk))
			{
				$this->show_error("model: non ho abbastanza parametri per caricare i dati");
				return false;
			} else {
				foreach ($this->pk as $keyfield=>$keyvalue)
				{
					$this->pk[$keyfield] = $id[$keyfield];
					$where[] = $keyfield." = ".$this->escape($id[$keyfield]);
				}
			}
		} else {
			$keys = array_keys($this->pk);
			$key = $keys[0];
			$this->pk[$key] = $id;
			$where[] = $key." = ".$this->escape($id);
		}
		$this->where = implode(' AND ', $where);

		$res = $this->query('SELECT * FROM '.$this->table.' WHERE '. $this->where);
		if ($res AND (mysql_num_rows($res)>1))
		{
			$this->show_error("model: piu' di un risultato nel caricamento dei dati");
			return false;
		}
		elseif (mysql_num_rows($res)==1)
		{
			mysql_data_seek($res, 0);
			$row = mysql_fetch_assoc($res);
			$this->data = $row;
			$this->loaded = true;

			$this->load_childs();
			return true;
		}
		else
		{
			$this->loaded = false;
			return false;
		}
	}

	// --------------------------------------------------------------------

	/**
	 * carica record correlati
	 **/
	public function load_childs()
	{
		$childs = array();

		//la chiave della tabella è su piu' campi .. non siamo preparati :)
		if (count($this->pk)>1) return;

		reset($this->pk);
		list($pk_name, $pk_value) = each($this->pk);

		//ho relazioni uno a molti con altre tabelle
		if (count($this->has_many)>0)
		{
			foreach($this->has_many as $fields => $rel_arr)
			{
				$id = $rel_arr['table_pk'];
				$res_se = $this->query('SELECT * FROM '.$rel_arr['table_name'].' WHERE '. $this->where);

				while ($r = mysql_fetch_assoc($res_se)) {
					foreach ($r as $field=>$value)
					{
						if ($field != $id AND $field != $pk_name){
							$this->data_rel[$fields][$r[$id]][$field] = $value;
						}
					}
				}
			}
		}
	}

	// --------------------------------------------------------------------

	/**
	 * inserisce record correlati
	 **/
	public function insert_childs()
	{
		$childs = array();

		//la chiave della tabella è su piu' campi .. non siamo preparati :)
		if (count($this->pk)>1) return;

		reset($this->pk);
		list($pk_name, $pk_value) = each($this->pk);

		//ho relazioni uno a molti con altre tabelle
		if (count($this->has_many)>0)
		{
			foreach($this->has_many as $fields => $rel_arr)
			{

				//if isset
				if (isset($this->data_rel[$fields]) AND count($this->data_rel[$fields]))
				{

					foreach ($this->data_rel[$fields] as $id=>$field_arr){

						$keys = array_keys($field_arr);
						array_unshift($keys,$pk_name,$rel_arr['table_pk']);

						$values = array_values($field_arr);
						array_unshift($values,$pk_value,$id);

						$escaped_values = array();
						foreach ($values as $value)
						{
							$escaped_values[] = $this->escape($value);
						}

						$sql_in = 'INSERT INTO '.$rel_arr['table_name']
							. '('.implode(',',$keys).')'
							.' VALUES '
							.' ('.implode(',',$escaped_values). ')';
						$res_in = $this->query($sql_in);

					}
				}
			}
		}
	}


	// --------------------------------------------------------------------

	/**
	 * aggiorna record correlati
	 **/
	public function update_childs()
	{
		$childs = array();

		//la chiave della tabella è su piu' campi .. non siamo preparati :)
		if (count($this->pk)>1) return;

		reset($this->pk);
		list($pk_name, $pk_value) = each($this->pk);

		//ho relazioni uno a molti con altre tabelle
		if (count($this->has_many)>0)
		{
			foreach($this->has_many as $fields => $rel_arr)
			{

				//if isset
				if (isset($this->data_rel[$fields]) AND count($this->data_rel[$fields]))
				{

					foreach ($this->data_rel[$fields] as $id=>$field_arr)
					{
						$keys = array_keys($field_arr);
						$set_arr = array();
						foreach ($field_arr as $key=>$value)
						{
							$set_arr[] = $key.' = '.  $this->escape($value);
						}

						$sql_up = 'UPDATE '.$rel_arr['table_name']
							.' SET '.implode(',',$set_arr)
							.' WHERE '.$this->where.' AND '.$rel_arr['table_pk'].' = '.$id;

						$res_up = $this->query($sql_up);
					}
				}
			}
		}
	}



	// --------------------------------------------------------------------

	/**
	 * rimuove record correlati
	 **/
	public function delete_childs()
	{
		$childs = array();

		//la chiave della tabella è su piu' campi .. non siamo preparati :)
		if (count($this->pk)>1) return;

		reset($this->pk);
		list($pk_name, $pk_value) = each($this->pk);

		//ho relazioni uno a molti con altre tabelle
		if (count($this->has_many)>0)
		{
			foreach($this->has_many as $fields => $rel_arr)
			{
				// Elimino i record della lingua
				$sql_de = 'DELETE FROM '.$rel_arr['table_name'].' WHERE '.$pk_name.' = ' . $this->escape($pk_value);
				$res_de = $this->query($sql_de);
			}
		}
	}




	// --------------------------------------------------------------------

	/**
	 * carica il record passando un id (il valore di una chiave primaria),
	 * puo' eventualmente essere un array.
	 **/
	public function loadWhere($where)
	{
		if (!$this->loaded)	$this->action = 'load';
		$this->where = $where;

		$res = $this->query('SELECT * FROM '.$this->table.' WHERE '. $this->where);
		if (mysql_num_rows($res)>1)
		{
			echo 'SELECT * FROM '.$this->table.' WHERE '. $this->where;
			$this->show_error("model: piu' di un risultato nel caricamento dei dati");
			return false;
		}
		elseif (mysql_num_rows($res)==1)
		{
			mysql_data_seek($res, 0);
			$row = mysql_fetch_assoc($res);
			$this->data = $row;
			$this->loaded = true;
			return true;
		}
		else
		{
			$this->loaded = false;
			return false;
		}
	}

	// --------------------------------------------------------------------

	/**
	 * quota un valore per una query sql (equivale a cleanDataForDb)
	 **/
	public function escape($str)
	{
		switch (gettype($str))
		{
			case 'string':
				//quoto ed escapo solo se NON smi passano funzioni mysql (todo: usare regex.. o aggiungere un metodo a set per saltare le quote)
			  if ($str == '') {
				$out = 'NULL';
			  } elseif (!in_array($str,array('NOW()'))) {
				//$out = (get_magic_quotes_gpc()) ? stripslashes($str) : $str;
				$out = "'". mysql_real_escape_string($str) ."'";
			  } else {
				$out = $str;
			  }
			break;
			case 'boolean':
				$out = ($str === FALSE) ? 0 : 1;
			break;
			default:
				$out = ($str === NULL) ? 'NULL' : $str;
			break;
		}
		return $out;
	}

	// --------------------------------------------------------------------

	/**
	 * esegue le query di insert
	 **/
	public function insert()
	{
		//INSERT
		$this->action = 'insert';

		//devo duplicare, quindi rimuovo le pk dai valori
		if ($this->loaded)
		{
			foreach ($this->pk as $keyfield => $keyvalue)
			{
				if(isset($this->data[$keyfield]))
					unset($this->data[$keyfield]);
			}
		}

		//assumo che la pk sia autoinc (se non è tra i campi previsti)
		$pk_ai = true;
		foreach ($this->pk as $keyfield => $keyvalue)
		{
			if(isset($this->data[$keyfield]))
			{
				$this->pk[$keyfield] = $this->data[$keyfield];
				$pk_ai = false;
			}
		}

		$keys = array_keys($this->data);
		$values = array();
		foreach (array_values($this->data) as $value)
		{
			$values[] = $this->escape($value);
		}


		if (count($values)<1)
		{

			$values = array_values($this->data);
		}

		$sql = 'INSERT INTO '.$this->table.' ('.implode(', ', $keys).') VALUES ('.implode(', ', $values).')';
		$result = $this->query($sql);

		//se la pk è autoinc la imposto all'ultimo insert_id, e carico il record
		if($result)
		{
			if ($pk_ai)
			{
				$this->loaded = true;
				$this->load(mysql_insert_id($this->conn_id));
			} else {
				$this->loaded = true;
				$this->load($this->pk);
			}


			//posso farlo solo dopo il load perchè devo usare la pk autoinc per salvare
			$this->insert_childs();
		} else {
			//echo $sql."..\n";
		}

		return $result;

	}



	// --------------------------------------------------------------------

	/**
	 * esegue le query di insert o update
	 **/
	public function update()
	{
		//UPDATE
		if ($this->loaded)
		{
			$this->action = 'update';

			if ($this->where == '')
			{
				$where = "";
				//aggiorno eventualmente la/le pk
				foreach ($this->pk as $keyfield => $keyvalue)
				{
					if(isset($this->data[$keyfield])){
						$this->pk[$keyfield] = $this->data[$keyfield];
						$where[] = $keyfield." = ".$this->escape($keyvalue);
					}
					if(isset($this->new_data[$keyfield])){
						$this->pk[$keyfield] = $this->new_data[$keyfield];
					}
				}

				if($where!="") $this->where = implode(' AND ', $where);
			}

			//se c'è almeno una variazione su un campo eseguo l'update
			if (count($this->new_data)>0)
			{
				foreach($this->new_data as $key => $val)
				{
					$valstr[] = $key." = ".$this->escape($val);
				}
				$result = $this->query('UPDATE '.$this->table.' SET '.implode(', ', $valstr).' WHERE '.$this->where);
				$this->update_childs();
				$this->load($this->pk);

			} elseif (count($this->data_rel)>0) {
				$this->update_childs();
				$result = true;
			} else {
				$result = true;
				$this->update_childs();
			}
			return $result;

		} else {
			die('Errore, record non caricato!');
		}
	}





	// --------------------------------------------------------------------

	/**
	 * verifica se un campo è univoco sulla tabella
	 * usato per prevenire violazioni di integrità ref.
	 **/
	public function isUnique($field, $value)
	{
		$res = $this->query('SELECT 1 FROM '.$this->table.' WHERE '.$field.'='.$this->escape($value));
		if (mysql_num_rows($res)>1)
		{
			return false;
		}
		elseif (mysql_num_rows($res)===1)
		{
			if ($this->loaded)
			{
				return ($this->data[$field] == $value);
			} else {
				return false;
			}
		} else {
			return true;
		}
	}

	// --------------------------------------------------------------------

	/**
	 * come il precedente ma usabile sugli array (per pk multiple)
	 **/
	public function areUnique($fields)
	{
		foreach($fields as $fieldname => $value)
		{
			$where[] = $fieldname." = ".$this->escape($value);
		}
		$where = implode(' AND ', $where);
		$res = $this->query('SELECT 1 FROM '.$this->table.' WHERE '.$where);

		if (mysql_num_rows($res)>1)
		{
			return false;
		}
		elseif (mysql_num_rows($res)===1)
		{
			if ($this->loaded)
			{
				foreach($fields as $fieldname => $value)
				{
					if($this->data[$fieldname] != $value) return false;
				}
				return true;
			}
			return false;
		} else {
			return true;
		}
	}

	// --------------------------------------------------------------------

	/**
	 * restituisce il valore di un campo
	 **/
	public function get($field)
	{
		if (isset($this->data[$field]))
		{
			return $this->data[$field];
		} else {
			return null;
		}
	}

	// --------------------------------------------------------------------

	/**
	* imposta il valore di un campo
	**/
	public function set($field, $value=null)
	{
		if (!isset($this->fields[$field]))
		{
			$this->data_rel[$field] = $value;
			return;
		}

		$field_meta = $this->fields[$field];
		if (in_array($field_meta->type,array("int","date","datetime")) && $value=="")
		{
			$value = null;
		}

		//popolo l'array new_data per aggiornare solo le variazioni
		if (isset($this->data[$field]))
		{
			if ($value !== $this->data[$field])
			$this->new_data[$field] = $value;
		} else {
			if (in_array($field,array_keys($this->fields)))
			{
				if ($this->loaded && is_null($value))
				{
					//è già nullo
				}
				else
				{
					$this->new_data[$field] = $value;
				}
			}
		}
		$this->data[$field] = $value;
	}

	// --------------------------------------------------------------------

	/**
	* imposta il valore dal post (se presente)
	**/
	public function setPostValue($field_name){
	    if(isset($_POST[$field_name])){
			$field_value = stripslashes_deep($_POST[$field_name]);
			$this->set($field_name, $field_value);
	    }
	}

	// --------------------------------------------------------------------

	/**
	* restituisce tutto l'array associativo del record caricato
	**/
	public function getData()
	{
		return $this->data;
	}

	/**
	* restituisce tutto l'array associativo del record caricato (ed eventuali altri dati correlati)
	**/
	public function getAllData()
	{
		$data = $this->data;
		$data = array_merge($data, $this->data_rel);
		return $data;
	}

	// --------------------------------------------------------------------

	/**
	* usa un array associativo per caricare una seria di campi
	**/
	public function setArray($fields)
	{
		foreach ($fields as $key=>$value)
		{
			$this->set($key,$value);
		}
	}


	// --------------------------------------------------------------------

	/**
	* cancella il record
	**/
	public function delete()
	{
		$this->action = 'delete';
		if ($this->loaded)
		{
			$result = $this->query('DELETE FROM '.$this->table.' WHERE '.$this->where);
			$this->delete_childs();
			return $result;
		} else {
			return false;
		}
	}

	// --------------------------------------------------------------------

	/**
	* recupera la qs con chiavi e valori della PK corrente
	**/
	public function getQueryString()
	{
		$qs_array = array();
		foreach ($this->pk as $keyfield => $keyvalue)
		{
			$qs_array[] = $keyfield.'='.rawurlencode($keyvalue);
		}
    return implode('&',$qs_array);
	}

}
?>