<?php
class DataGrid {
	public static $id = 0;
	public $datagrid_functions;
	public $is_ajax = false;

	public $cellpadding;
	public $cellspacing;
	public $caption;
	public $css_class;
	public $table_id;
	public $url;
	public $form;
	public $pagination = '';

	public $reset_on_sort;
	public $primary_key;
	public $filename;

	const GRID_FORMAT   = "<div id=\"datagrid_%s\">\n%s\n</div>";
	const TABLE_FORMAT   = "<table%s>\n%s\n</table>";
	const CAPTION_FORMAT = "<caption>%s</caption>\n";
	const A_FORMAT       = '<a href="%s">%s</a>';
	const TR_FORMAT      = "<tr%s>\n%s</tr>\n";
	const TD_FORMAT      = " <td%s>%s</td>\n";
	const TH_FORMAT      = "<th %s>%s</th>\n";

	public function __construct(DataTable $data_table = null) {
		self::$id++;
		$this->url = basename($_SERVER['PHP_SELF']);
		if (!is_null($data_table)) {
			$this->data_table = $data_table;
		} else {
			$this->data_table = new DataTable();
		}
		$this->cellpadding   = 0;
		$this->cellspacing   = 1;
		$this->table_id      = '';
		$this->css_class     = 'datagrid';
		$this->reset_on_sort = true;
		$this->datagrid_functions = new DataGridFunctionCollection();
	}

	public function getGrid() {

		if (qs_value('ajax_grid'))
		{
			$this->is_ajax = true;
		}

		if (qs_value('export_grid_'.(string)self::$id))
		{
			echo $this->getCsv();
			die;
		}

		if (qs_value('print_grid_'.(string)self::$id))
		{
			echo $this->printGrid();
			die;
		}

		$tr_array = array();

		// Riga con intestazione di colonne
		$th_array = array();
		if (!$this->is_ajax){
			$tr_array[] = sprintf(self::TR_FORMAT, '', $this->makeTableTH());
		}
		// Righe
		$counter = 1;

		foreach ($this->data_table->rows as $row) {

			if($row->css_class == '') {
				$row->css_class = ($counter%2)? '' : 'tr_alternate';
			}
			$counter++;
			$td_array = array();

			foreach ($this->data_table->columns as $k=>$v) {
				$attributes = '';
				$content    = '#ERR#';
				$spacial_row = false;
				if (isset($row->cells->$k)) {
					$cell = $row->cells->$k;
					$content = $cell->value;
					// Controllo che la cella non abbia uno stile, altrimenti lo applico
					if ($cell->css_class != '') {
						$attributes .= ' class="'. $cell->css_class .'"';
					}
					if ($cell->title != '') {
						$attributes .= ' title="'. $cell->title .'"';
					}
					if ($cell->style != '') {
						$attributes .= ' style="'. $cell->style .'"';
					}

				}

				if (($this->data_table->hasForm()) and isset($_POST[$k]) and $_POST[$k]!=''){
					if (!$row->is_form)
					$content = str_ireplace($_POST[$k],'<span class=\'highlight\'>'.$_POST[$k].'</span>', $content);
				}

				$td_array[] = sprintf(self::TD_FORMAT, $attributes, $content);

			}

			// Se ci sono funzioni nella collection devo aggiungere l'altra colonna
			if ($this->primary_key) {
				$primary_key = $this->primary_key;
			} else {
				foreach ($this->data_table->columns as $k=>$v) {
					$primary_key = array($v->column_name);
					break;
				}
			}
			$functions = array();
			foreach ($this->datagrid_functions as $func)
			{
				foreach ($primary_key as $value)
				{
					$func->addParam($value, $row->cells->$value->value);
				}
				if ( $row->is_form )
				{
					$functions[] = '';
				}
				else
				{
					if(isset($func->callback))
					{
						$str_function = call_user_func($func->callback, $row, $func);
					}
					else
					{
						$str_function = $func->getFunction();
					}
					$functions[] = $str_function;
				}
			}
			if (count($functions) > 0) {
				$td_array[] = sprintf(self::TD_FORMAT, ' class="function"', implode(' ', $functions));
			}

			$td_str_output = implode(null, $td_array);
			// Controllo che la riga non abbia uno stile, altrimenti lo applico
			$attributes = '';
			$css_type = ($row->is_form) ? 'tr_filter' : 'tr_row';
			$css_class = ($row->css_class!='') ? ' '.$row->css_class : '';
			$attributes = ' class="'.$css_type.$css_class.'"';

			if ($row->is_form){
				if ($this->is_ajax) continue;
				$focus = (isset($_POST['focus']))? "<script>$('".$_POST['focus']."').focus()</script>" : "";
				$tr_array[] ='<form method="post" action="" id="ajax_filter">'.sprintf(self::TR_FORMAT, $attributes, $td_str_output).'<input type="hidden" name="focus" id="focus" value="" /></form>'.$focus;
			} else {
				$tr_array[] = sprintf(self::TR_FORMAT, $attributes, $td_str_output);
			}

		}
		$tr_output = implode(null, $tr_array);

		if ($this->is_ajax){
			echo $tr_output;
			echo $this->pagination;
			die;
		}


		$caption_output = '';
		if ($this->caption != '') {
			$caption_output = sprintf(self::CAPTION_FORMAT, $this->caption);
		}

		$table_output = $caption_output . $tr_output;
		$table_output = sprintf(self::TABLE_FORMAT, $this->makeTableAttributes(), $table_output);
		$table_output .= $this->pagination;
		return $table_output;
	}



	public function getCsv() {
		$output = '';
		$filename = ($this->filename!='') ? clean_filename($this->filename).'.csv' : 'export.csv';
		header('Pragma: private');
		header('Cache-control: private, must-revalidate');
		header("Content-type: csv/xml;");
		header("Content-Disposition: attachment; filename=" . $filename);

		//labels
		foreach ($this->data_table->columns as $k=>$v) {
			if ($v->caption) {
				if ($v->caption == 'Funzioni') continue;
				$labels[]  = strip_tags($v->caption);
			} else {
				$labels[]  = $k;
			}
		}
		$output .= '"'.implode('";"',$labels).'"'."\r\n";

		//rows
		foreach ($this->data_table->rows as $row) {
			unset($values);
			if($row->is_form) continue;
			foreach ($this->data_table->columns as $k=>$v) {
				if ($v->caption == 'Funzioni') continue;
				$cell = $row->cells->$k;
				$content = strip_tags($cell->value);
				$values[] = str_replace('"','""',$content);
			}
			$rows[] = '"'.implode('";"',$values).'"';
		}
		$output .= implode("\r\n",$rows)."\r\n";
		return mb_convert_encoding($output, 'iso-8859-1', 'utf-8');
	}



	public function printGrid() {
		$tr_array = array();

		// Riga con intestazione di colonne
		$th_array = array();
		foreach ($this->data_table->columns as $k=>$v) {
			if ($v->caption == 'Funzioni') continue;
			if ($v->caption) {
				$label = $v->caption;
			} else {
				$label = $k;
			}
			$th_array[] = sprintf(self::TH_FORMAT, '', $label);
		}
		$tr_array[] = sprintf(self::TR_FORMAT, '', implode('', $th_array));

		// Righe
		$counter = 1;
		foreach ($this->data_table->rows as $row) {
			if($row->is_form) continue;
			if($row->css_class == '') {
				$row->css_class = ($counter%2)? '' : 'tr_alternate';
			}
			$counter++;
			$td_array = array();

			foreach ($this->data_table->columns as $k=>$v) {
				if ($v->caption == 'Funzioni') continue;
				$attributes = '';
				$content    = '#ERR#';
				$spacial_row = false;
				if (isset($row->cells->$k)) {
					$cell = $row->cells->$k;
					$content = $cell->value;
					// Controllo che la cella non abbia uno stile, altrimenti lo applico
					if ($cell->css_class != '') {
						$attributes .= ' class="'. $cell->css_class .'"';
					}
					if ($cell->title != '') {
						$attributes .= ' title="'. $cell->title .'"';
					}
					if ($cell->style != '') {
						$attributes .= ' style="'. $cell->style .'"';
					}
				}
				$td_array[] = sprintf(self::TD_FORMAT, $attributes, $content);
			}


			$td_str_output = implode(null, $td_array);
			// Controllo che la riga non abbia uno stile, altrimenti lo applico
			$attributes = '';
			if ($row->css_class != '') {
				$attributes .= ' class="'. $row->css_class .'"';
			}
			if ($row->is_form){
			} else {
				$tr_array[] = sprintf(self::TR_FORMAT, $attributes, $td_str_output);
			}


		}
		$tr_output = implode(null, $tr_array);

		$caption_output = '';
		if ($this->caption != '') {
			$caption_output = sprintf(self::CAPTION_FORMAT, $this->caption);
		}


		$table_output = '
		<style>
		* {
			font-size: 11px;
			font-family: Verdana, Arial, Helvetica, sans-serif;
		}
		.datagrid {
			width: 100%;
			padding: 5px;
			border: 1px solid #CED9DF;
		}
		.datagrid th {
			white-space: nowrap;
			border-top: 1px solid #ccc;
			border-right: 1px solid #ccc;
			border-bottom: 1px solid #ccc;
			padding: 4px;
		}
		.datagrid td {
			border-bottom: 1px solid #ccc;
			border-right: 1px solid #ccc;
			padding: 4px;
		}
		 .datagrid td:first-child
		,.datagrid th:first-child {
			border-left: 1px solid #ccc;
		}
		.datagrid caption {
			text-align: left;
		}
		 .datagrid .alg_center
		,.datagrid .function
		{
			text-align: center;
		}
		.datagrid .tr_highlight {
			background-color: yellow;
			color: black;
		}
		.datagrid .tr_alternate {
			background-color: #eee;
			color: black;
		}
		</style>
		';
		$table_output .= $caption_output . $tr_output;
		$table_output  = sprintf(self::TABLE_FORMAT, $this->makeTableAttributes(), $table_output);
		$table_output .= '<script>print()</script>';
		return $table_output;
	}





	public function getExportLink($filename='') {
		$this->filename = $filename;
		$url = qs_append('export_grid_'.(string)self::$id, "1");
		return '<a href="'.$url .'" target="blank"><img src="images/page_white_excel.png" style="vertical-align:middle" /> Export</a>';
	}

	public function getPrintLink() {
		$url = qs_append('print_grid_'.(string)self::$id, "1");
		return '<a href="'.$url .'" target="blank"><img src="images/printer.png" style="vertical-align:middle" /> Print</a>';
	}

	private function makeTableAttributes() {
		$array_attributes = array(
			 'cellpadding'=>$this->cellpadding
			,'cellspacing'=>$this->cellspacing
			,'class'      =>$this->css_class. ' ui-corner-all'
			,'id'         =>'datagrid_'.(string)self::$id
		);

		$str_attributes = '';
		foreach ($array_attributes as $k=>$v) {
			if ($v !== '') {
				$str_attributes .= " $k=\"$v\"";
			}
		}
		return $str_attributes;
	}

	private function makeTableTH() {
		$str_columns = '';
		$th_array    = array();
		foreach ($this->data_table->columns as $k=>$v) {
			if ($v->caption) {
				$label = $v->caption;
			} else {
				$label = $k;
			}
			if ($v->sortable) {
				$label = sprintf(self::A_FORMAT, $this->makeSortLink($v), $label);
			}

			$css_class = '';
			$style = '';
			if ($v->style != '') {
				$style = ' style="'. $v->style .'" ';
			}
			$th_array[] = sprintf(self::TH_FORMAT, $css_class.$style, $label);
		}

		// Se ci sono funzioni nella collection devo aggiungere l'altra colonna
		foreach ($this->datagrid_functions as $func) {
			$th_array[] = sprintf(self::TH_FORMAT, '', 'Funzioni');
			break;
		}

		$str_columns = implode(null, $th_array);
		return $str_columns;
	}


	private function makeSortLink(DataColumn $column) {
		$link_format = '%s?order_col=%s&amp;order_dir=%s';

		$page_name   = $this->url;
		$direction   = 'ASC';

		$getdir  = '';
		$getcol  = '';
		$get_arr = array();

		foreach ($_GET as $k=>$v) {
			switch ($k) {
				case 'order_dir':
					$getdir = $_GET['order_dir'];
					break;

				case 'order_col':
					$getcol = $_GET['order_col'];
					break;

				case 'pag':
					if (!$this->reset_on_sort) {
						$get_arr[] = "$k=$v";
					}
					break;

				default:
					$get_arr[] = "$k=$v";
					break;
			}
		}

		if ($getcol === $column->sortable_field) {
			switch ($getdir) {
				case 'DESC':
					$direction = 'ASC';
					break;

				case 'ASC':
				default:
					$direction = 'DESC';
					break;
			}
		}
		$sort_link = sprintf($link_format, $page_name, $column->sortable_field, $direction);

		if (count($get_arr) > 0) {
			$sort_link .= '&' . implode('&amp;', $get_arr);
		}
		return $sort_link;
	}
}
class DataGridFunction {
	public $uname;
	public $image;
	public $page_link;
	public $title;
	public $onclick;
	public $target;
	public $callback;

	private $params;

	const A_FORMAT   = '<a href="%s"%s>%s</a>';
	const IMG_FORMAT = '<img src="%s" alt="%s" title="%s" />';

	public function __construct($uname, $page_link) {
		$this->uname      = (string)$uname;
		$this->image      = '';
		$this->page_link  = (string)$page_link;
		$this->title      = (string)$uname;
		$this->params     = array();
	}

	public function addParam($param_name, $param_value)
	{
		$key = (string)$param_name;
		$val = (string)$param_value;
		$this->params[$key] = $val;
	}

	public function getFunction()
	{
		$str_inlink = (($this->title != '')? $this->title : $this->uname);
		if ($this->image != '') {
			$str_inlink = sprintf(
				 self::IMG_FORMAT
				,$this->image
				,$this->uname
				,$this->title);
		}
		$this->params['action'] = $this->uname;
		$array_params = array();
		foreach ($this->params as $k=>$v) {
			$array_params[] = "$k=$v";
		}
		$href = $this->page_link .'?'. implode('&amp;', $array_params);
		$attributes = array();
		if ($this->onclick) {
			$attributes[] = 'onclick="'. $this->onclick .'"';
		}
		if ($this->target) {
			$attributes[] = 'target="'. $this->target .'"';
		}
		if(count($attributes))
		{
			$attributes = ' '. implode(' ', $attributes);
		}
		else
		{
			$attributes = '';
		}
		return sprintf(self::A_FORMAT, $href, $attributes, $str_inlink);
	}
}
class DataGridFunctionCollection {
	public function add(&$datagrid_function) {
		$name = ($datagrid_function->uname);
		$this->$name = $datagrid_function;
	}
	public function remove(&$datagrid_function) {
		$name = ($data_column->uname);
		unset($this->$name);
	}
}
?>