<?php


class DataFilter
{
	public $form;
	public $namespace;

	public function __construct(Form $form = null) {
		if (!is_null($form)) {
			$this->form = $form;
		} else {
			$this->form = new Form();
		}
	}

	protected function setNamespace() {
		if ($this->namespace==''){
			$hash = '';
			foreach ($this->form->fields as $field_name=>$field){
				$hash .= $field->id;
			}
			$this->namespace = md5($hash);
		}
	}

	protected function setValue() {

		foreach ($this->form->fields as $field_name=>$field){
			$field->setPostValue();
			if ( (isset($field->type) && !in_array($field->type,array('submit','reset')))  OR is_a($field, 'SelectField') OR is_a($field, 'AutocompleterField'))
			{
				if ((isset($_POST) && isset($_POST[$field->name])))
				{
					if (!isset($_SESSION[$this->namespace]))
					{
						$_SESSION[$this->namespace] = array('filter'=>array());
					}
					$_SESSION[$this->namespace]['filter'][$field->name] = $field->value;
				}
				else
				{
					$field->value = @$_SESSION[$this->namespace]['filter'][$field->name];
				}
			}
		}
	}

	public function getValue($fieldname) {
		if (isset($_POST) && isset($_POST[$fieldname]))
		{
			return $_POST[$fieldname];
		} elseif(isset($_SESSION[$this->namespace]) && $_SESSION[$this->namespace]['filter'][$fieldname]) {
			return $_SESSION[$this->namespace]['filter'][$fieldname];
		}
		return '';
	}


	public function getWhere() {

		$this->setNamespace();
		$this->setValue();

		$where_arr = array();
		$where_str = '';

		foreach ($this->form->fields as $field_name => $field){
			$field->css_class = 'datafilter_input';

			if (isset($_SESSION[$this->namespace]['filter'][$field->name]))
			{

				$value = $field->value;

				if (isset($field->value_callback)){
					$value = call_user_func_array($field->value_callback, array($value));
				}

				if (isset($field->strip_first_value)){
					$value = substr($value, 1);
				}
				
				if (isset($field->clause)){
					if ($field->clause === false)
						continue;
					if ($value != '')
					$where_arr[] = $field->db_name .' '.$field->clause.' '. cleanDataForDb($value);

				} elseif (is_a($field, 'InputField')){
					if (!in_array($field->type,array('submit','reset')))
					{
						if ($value != '')
							$where_arr[] = $field->db_name .' LIKE "%' . $value .'%"';
					}

				} else {
					if ($value != '')
						$where_arr[] = $field->db_name .' = ' .  cleanDataForDb($value);
				}
			}
		}
		$where_str = implode(' AND ', $where_arr);
		return $where_str;
	}

	public function getFilter() {

		$this->setNamespace();
		$this->setValue();

		return  $this->form->getForm();
	}

	public function getPrintFilter() {

		$this->setNamespace();
		$this->setValue();
		//$form = clone($this->form);
		$this->form->is_readonly = true;
		return  $this->form->getForm();
	}


	public function getFilterRow(Datatable $table, $timeout=0) {

		$row = $table->newRow();
		$row->is_form = true;
		foreach ($table->columns as $k=>$v) {
				$cell = $row->cells->$k->value = '&nbsp;';
		}
		$post_url = qs_append('ajax_grid',1);

		foreach ($this->form->fields as $field_name=>$field){

			if ($timeout>0)
			{
				$field->onkeyup = "clearTimeout(datafilter_timeout);  datafilter_timeout = setTimeout(function(){ datafilter_post('".$post_url."','datagrid_1') }, ".(int)$timeout.");";
			} else {
				$field->onkeyup = "datafilter_post('".$post_url."','datagrid_1')";
			}
			//'$.ajax({type: \'post\', dataType: \'html\',  url: \''.$post_url.'\', data:$(\'#ajax_filter\').serialize(),  success: function(html){ $(\'.tr_row\').remove(); $(\'#datagrid_1 tr:last\').after(html.replace(/(<div.*<\/div>)/, \'\')); $(\'.pagination\').html($(html).filter(\'div\').html()); }});';

			$field->autocomplete = "off";
			$field->style = "width:95%";
			$row->cells->add(new DataCell($field->name, $field->getField()));
		}
		return $row;
	}

}

?>