<?php

/**
 * Questa classe si occupa di scrivere 
 * su file i vari messaggi da loggare
 */
class WebSiteLog {
	/**
	 * Array con i nomi dei file di log
	 *
	 * @var array
	 */
	private $file_names = array(
		 'debug'=>'debug.log'
		,'error'=>'error.log'
		,'main' =>'main.log'
	);

	/**
	 * Stringa contenente il percorso al file
	 *
	 * @var string
	 */
	private $file_path = LOGS_DIR;

	/**
	 * Valore boleano per la verifica 
	 * dell'installazione della libreria ZLIB
	 *
	 * @var bool
	 */
	private $zlib = false;

	/**
	 * La grandezza massima del file 
	 * in bytes prima di essere archiviato
	 *
	 * @var int
	 */
	private $file_size = 10485760;

	/**
	 * Costruttore della classe a cui passare 
	 * il percorso dei file di log
	 *
	 * @param string $file_path
	 * @return WebSiteLog
	 */
	public function __construct() {
		if (!is_dir($this->file_path)) {
			die('Path per i file di log non valida.');
		}

		foreach ($this->file_names as $file) {
			if (!file_exists($this->file_path . $file)) {
				if( !touch($this->file_path . $file) ) {
					die('Non riesco a fare il touch del file ' . $file .'.');
				} else {
					chmod($this->file_path . $file, 0777);
				}
			} else {
				if (!is_writable($this->file_path . $file)) {
					die('Il file '. $file .' non è scrivibile.');
				}
			}
		}

		if (function_exists('gzopen')) {
			$this->zlib = true;
		}
	}

	/**
	 * Questo metodo scrive il messaggio nel file main.log
	 *
	 * @param string
	 */
	public function WriteMainLog($message) {
		$file = $this->file_path . $this->file_names['main'];
	    $now = strftime('%a %b %d %H:%M:%S %Y');
	    $contents = "[$now] [main] $message\n" ;
	    $this->WriteLog($contents, $file);
	}

	/**
	 * Questo metodo scrive il messaggio nel file error.log
	 *
	 * @param string
	 */
	public function WriteErrorLog($message) {
		$file = $this->file_path . $this->file_names['error'];
	    $now = strftime('%a %b %d %H:%M:%S %Y');
	    $contents = "[$now] [error] $message\n" ;
	    $this->WriteLog($contents, $file);
	}

	/**
	 * Questo metodo scrive il messaggio nel file debug.log
	 *
	 * @param string
	 */
	public function WriteDebugLog($message) {
		$file = $this->file_path . $this->file_names['debug'];
	    $now = strftime('%a %b %d %H:%M:%S %Y');
	    $contents = "[$now] [debug] $message\n" ;
	    $this->WriteLog($contents, $file);
	}

	private function WriteLog($contents, $file) {
		if (filesize($file) >= $this->file_size) {
			if ($this->zlib) {
				for ($i=1;;$i++) {
					$new_file_name = "$file.$i.gz";
					if (!file_exists($new_file_name)) {
						$zp = gzopen($new_file_name, "w9");
						gzwrite($zp, file_get_contents($file));
						gzclose($zp);
						unlink($file);
						break;
					}
				}
			} else {
				for ($i=1;;$i++) {
					$new_file_name = "$file.$i";
					if (!file_exists($new_file_name)) {
						rename($file, $new_file_name);
					}
				}
			}

			if( !touch($file) ) {
				die('Non riesco a fare il touch del file ' . $file .'.');
			} else {
				chmod($file, 0777);
			}
		}

	    if (!$handle = fopen($file, 'a')) {
	         die("Non riesco ad aprire il file: $file");
	    }
	    if (fwrite($handle, $contents) === FALSE) {
	        die("Non si riesce a scrivere nel file: $file");
	    }	
	    fclose($handle);
	}
}
?>