<?php
class AdminModel extends Model
{
	public function __construct($table)
	{
		global $dbConnOne;
		parent::__construct($table, $dbConnOne);
	}

	public function insert()
	{
		$this->set('date_ins', 'NOW()');
		$result = parent::insert();
		return $result;
	}

	public function update()
	{
		$this->set('date_upd', 'NOW()');
		$result = parent::update();
		return $result;
	}
}

class Utente extends AdminModel
{
	public function __construct()
	{
		parent::__construct(UTENTI_TABLE);
	}
}

class Gruppo extends AdminModel
{
	public function __construct()
	{
		parent::__construct(GRUPPI_TABLE);
	}
}

class Config extends AdminModel
{
	public function __construct()
	{
		parent::__construct(CONFIG_TABLE);
	}
}

class Categoria extends AdminModel
{
	public function __construct()
	{
		parent::__construct(CATEGORIE_TABLE);
	}
}

class CrawlConversano extends AdminModel
{
	public function __construct()
	{
		parent::__construct(CRAWLS_CONVERSANO_TABLE);
	}
	
	public function delete()
	{	
		parent::delete();
	}
}

class CrawlLecce extends AdminModel
{
	public function __construct()
	{
		parent::__construct(CRAWLS_LECCE_TABLE);
	}
	
	public function delete()
	{	
		parent::delete();
	}
}

class Notizia extends AdminModel
{
	public function __construct()
	{
		parent::__construct(NOTIZIE_TABLE);
	}
	
	public function delete()
	{	
		parent::delete();
	}
}

class Doc extends AdminModel
{
	public function __construct()
	{
		parent::__construct(DOCS_TABLE);
	}

	public function insert($file, $notizia_id)
	{
		if($file)
		{
            @chmod(DOCS_DIR . $file, 0666);

            $this->set('date_ins', 'NOW()');
            $this->set('file', $file);
            $this->set('notizia_id', $notizia_id);
                
			$result = parent::insert();
			$last_id = mysql_insert_id();
			
            return $last_id;
		}
		else
		{
			return false;
		}
	}

	public function update($userfile)
	{
		// Non è possibile fare l'update delle immagini
		return false;
	}

	public function delete()
	{
		$file = $this->get('file');
		if($file)
		{
			@unlink(DOCS_DIR      . $file);
		}
		$result = parent::delete();
		return $result;
	}
}

class Immagine extends AdminModel
{
	public function __construct()
	{
		parent::__construct(IMMAGINI_TABLE);
	}

	public function insert($immagine, $notizia_id)
	{
		if($immagine)
		{
	        @copy(IMMAGINI_DIR_DST . $immagine, IMMAGINI_DIR_SRC . $immagine);
	        @copy(IMMAGINI_DIR_DST . $immagine, IMMAGINI_DIR_THUMBS . $immagine);
			
            @chmod(IMMAGINI_DIR_SRC . $immagine, 0666);
            @chmod(IMMAGINI_DIR_DST . $immagine, 0666);
            @chmod(IMMAGINI_DIR_THUMBS . $immagine, 0666);
                
            $this->set('date_ins', 'NOW()');
            $this->set('immagine', $immagine);
            $this->set('notizia_id', $notizia_id);
                
			$result = parent::insert();
			$this->makeThumbs();
			$last_id = mysql_insert_id();
			
            return $last_id;
            
		}
		else
		{
			return false;
		}
	}

	public function update($userfile)
	{
		// Non è possibile fare l'update delle immagini
		return false;
	}

	public function delete()
	{
		$immagine = $this->get('immagine');
		
		if($immagine)
		{
			@unlink(IMMAGINI_DIR_SRC		. $immagine);
			@unlink(IMMAGINI_DIR_DST		. $immagine);
			@unlink(IMMAGINI_DIR_THUMBS		. $immagine);
		}
		$result = parent::delete();
		
		return $result;
	}
	
	public function makeThumbs()
	{
		$file = $this->get('immagine');
	 	createthumbf(IMMAGINI_DIR_SRC . $file, IMMAGINI_DIR_SRC . $file, 400, 320, 2);
	 	createthumbf(IMMAGINI_DIR_DST . $file, IMMAGINI_DIR_DST . $file, 220, 165, 2);
	 	createthumbf(IMMAGINI_DIR_THUMBS . $file, IMMAGINI_DIR_THUMBS . $file, 174, 101, 2);
	}
}



?>
