<?php
include('pagestart.php');

if(!$permissions['sys']['gestione_utenti']) {
	header('Location: access_denied.php');
	exit;
}


$page_array = array(
	 'page_title'  =>'Utenti'
	,'sub_title'   =>'Inserisci utente'
	,'form'        =>''
);

$obj_utente = new Utente();

$action = 'insert';
if (isset($_GET['action'])) {
	switch ($_GET['action']) {

		case 'edit':
			if (isset($_GET['user_id'])) {
				$page_array['sub_title'] = 'Modifica utente';
				if ($obj_utente->load($_GET['user_id'])) {
					$action = 'edit';
					$row_se = $obj_utente->getData();
				} else {
					die('Si è verificato un errore, utente non trovato.');
				}
			}
			break;

		case 'delete':
			if (isset($_GET['user_id']))
			{
				if ($obj_utente->load($_GET['user_id']))
				{
					$obj_utente->delete();
				}
				header('Location: users.php');
				exit;
			}
			break;
	}
}






$obj_fm = new Form();

$obj_rule = new Rule();
$obj_rule->required = true;

$group = new SelectField('group_id', 'Gruppo', (($action=='edit')? $row_se['group_id'] : array()));
$group->rule  = $obj_rule;
$obj_fm->fields->add($group);

$field = new InputField('text', 'firstname', 'Nome', (($action=='edit')? $row_se['firstname'] : ''));
$field->rule  = $obj_rule;
$obj_fm->fields->add($field);

$field = new InputField('text', 'lastname', 'Cognome', (($action=='edit')? $row_se['lastname'] : ''));
$field->rule  = $obj_rule;
$obj_fm->fields->add($field);

$field = new InputField('text', 'uname', 'Username', (($action=='edit')? $row_se['uname'] : ''));
$field->rule  = $obj_rule;
$obj_fm->fields->add($field);

if ($action == 'insert'){
	$field = new InputField('password', 'password', 'Password');
	$field->rule  = $obj_rule;
	$obj_fm->fields->add($field);
} else {
	$field = new InputField('password', 'password', 'Nuova Password');
	$obj_fm->fields->add($field);
}


$save = new InputField('submit', 'submit', '', 'Salva');
$obj_fm->fields->add($save);


$obj_validator = new Validator();
$obj_validator->fields = $obj_fm->fields;
if (isset($_POST) && count($_POST)) {
	foreach ($obj_fm->fields as $field) {
		if (isset($_POST[$field->name])) {
			if (is_array($_POST[$field->name])) {
				$field->value = $_POST[$field->name];
			} else {
				$field->value = stripslashes($_POST[$field->name]);
			}
			$obj_utente->set($field->name, $field->value);
		}
	}

	$res = false;
	$is_valid = $obj_validator->isValid();

	$esclusion_where = (($action=='edit')? 'user_id!='.$obj_utente->get('user_id') : '');
	if (!is_unique_in_table('uname', $_POST['uname'], UTENTI_TABLE, $dbConnOne, $esclusion_where)) {
		$obj_validator->setCustomError($obj_fm->fields->uname, 'Esiste un utente con lo stesso username nel sistema');
		$is_valid = false;
	}


	if ($obj_validator->isValid()){
		switch ($action) {
		 	case 'insert':
		 		$obj_utente->set('upasswd', md5($_POST['password']));
		 		$res = $obj_utente->insert();
				$last_id = mysql_insert_id();
		 		break;

		 	case 'edit':
				if ($_POST['password']!='')
					$obj_utente->set('upasswd', md5($_POST['password']));
		 		$res = $obj_utente->update();
		 		$last_id = $obj_utente->get('group_id');
		 		break;
		}
		if ($res) {
			header('Location: users.php?last_id='. $last_id);
			exit;
		} else {
			$obj_validator->setCustomError($obj_validator->fields->submit, 'Si è verificato un errore nel salvataggio.');
		}
	}
}

$sql_se = 'SELECT * FROM '. GRUPPI_TABLE .' ORDER BY `name`';
$res_se = mysql_query($sql_se);
$arr_gr = array(''=>'- seleziona -');
while($r = mysql_fetch_assoc($res_se)) {
	$arr_gr[$r['group_id']] = $r['name'];
}
$group->setOptions($arr_gr);

$page_array['form'] = $obj_fm->getForm();
$smarty->assign($page_array);
$smarty->display('generic_form.tpl');
?>
