<?php
include('pagestart.php');

if(!$permissions['sys']['gestione_utenti']) {
	header('Location: access_denied.php');
	exit;
}

$pageArray = array(
	 'page_title' =>'Utenti'
	,'sub_title'  =>'Elenco utenti'

	,'datafilter' =>''
	,'datagrid' =>''
	,'exportlink' =>''
	,'printlink' =>''
	,'menu2'      =>array(
		array(
			 'page' =>'users_edit.php'
			,'title'=>'Aggiungi utente'
			,'image'=>'shape_square_add.png'
		)
	)
);

//unset($_SESSION);
$filter = new DataFilter();
$filter->namespace = 'utenti';
$filter->form->fields->add(new InputField('text', 'uname', 'Username'));
$filter->form->fields->add(new InputField('text', 'nominativo', 'Nominativo'));
$filter->form->fields->nominativo->db_name = 'CONCAT_WS(" ", u.firstname, u.lastname)';
$filter->form->fields->add(new InputField('submit', 'submit', '', 'Filtra'));
$pageArray['datafilter'] = '';//$filter->getFilter();



$last_id = 0;
if (isset($_GET['last_id'])) {
	$last_id = $_GET['last_id'];
}
$sql = 'SELECT ' .
		'u.user_id' .
		', u.uname' .
		', CONCAT_WS(" ", u.firstname, u.lastname) AS nominativo' .
		', g.name AS gruppo ' .
		'FROM '. UTENTI_TABLE .' u ' .
		'LEFT JOIN '. GRUPPI_TABLE .' g ON g.group_id = u.group_id';
		if ($filter->getWhere())
		 $sql .= ' WHERE '. $filter->getWhere();

//echo $sql;
$obj_dataset = new DataSet($sql, $dbConnOne);
//$obj_dataset->limit = 1;
$array_data  = $obj_dataset->getData();

$obj_datatable = new DataTable();
$obj_datatable->columns->add(new DataColumn('user_id',    'ID'));
$obj_datatable->columns->add(new DataColumn('uname',      'Username'));
$obj_datatable->columns->add(new DataColumn('nominativo', 'Nome e cognome'));
$obj_datatable->columns->add(new DataColumn('gruppo',     'Gruppo'));
$obj_datatable->columns->add(new DataColumn('funzioni', 'Funzioni'));
$obj_datatable->columns->funzioni->sortable = false;

/*
$row = $obj_datatable->newRow();
$row->cells->add(new DataCell('uname', 'x'));
$obj_datatable->rows->add($row);
*/

$obj_datatable->rows->add($filter->getFilterRow($obj_datatable));

foreach ($array_data as $data) {
	$row = $obj_datatable->newRow();
	$data['funzioni'] = '';

	foreach ($data as $k=>$v) {
		if ($k == 'funzioni') {
			$v  = '<a href="users_edit.php?user_id='.$data['user_id'].'&amp;action=edit"><img src="images/shape_square_edit.png" alt="edit" title="edit" /></a> ';
			if ($data['user_id']!=1)
			{
				$v .= '<a href="users_edit.php?user_id='.$data['user_id'].'&amp;action=delete" onclick="return confirm_delete();"><img src="images/shape_square_delete.png" alt="delete" title="delete" /></a> ';
			}
		}
		$row->cells->add(new DataCell($k, $v));
	}
	if ($row->cells->user_id->value === $last_id) {
		$row->css_class = 'tr_highlight';
	}
	$obj_datatable->rows->add($row);
}



$obj_datagrid = new DataGrid($obj_datatable);
$obj_datagrid->caption = 'Elenco Utenti';
$obj_datagrid->pagination = $obj_dataset->getLinks();
$pageArray['exportlink'] = $obj_datagrid->getExportLink($pageArray['sub_title']);
$pageArray['printlink'] = $obj_datagrid->getPrintLink();
$pageArray['datagrid'] = $obj_datagrid->getGrid();


$smarty->assign($pageArray);
$smarty->display('generic_datagrid.tpl');
?>
