<?php
include('pagestart.php');

$page_array = array(
	 'page_title'  =>'Categorie clienti'
	,'sub_title'   =>'Inserisci categoria'
);

$obj_categoria = new Categoria();

$action = 'insert';
if (isset($_GET['action']))
{
	switch ($_GET['action'])
	{
		case 'edit':
			if (isset($_GET['ca_id']))
			{
				$page_array['sub_title'] = 'Modifica categoria';
				if ($obj_categoria->load($_GET['ca_id']))
				{
					$action = 'edit';
					$row_se = $obj_categoria->getData();
				}
				else
				{
					die('Si è verificato un errore, record non trovato.');
				}
			}
			break;

		case 'delete':
			if (isset($_GET['ca_id']))
			{
				if ($obj_categoria->load($_GET['ca_id']))
				{
					$str_format = 'Categoria (%s|%d) eliminata da (%s|%d)';
					$args = array(
						 $obj_categoria->get('nome')
						,$obj_categoria->get('ca_id')
						,$ret['uname']
						,$ret['user_id']
					);
					$log = vsprintf($str_format, $args);
					$WebSiteLogObj->WriteMainLog($log);

					$obj_categoria->delete();
				}
				else
				{
					die('Si è verificato un errore, record non trovato.');
				}
				header('Location: categorie.php');
				exit;
			}
			break;
	}
}
$obj_fm = new Form();

$obj_rule = new Rule();
$obj_rule->required = true;

$field = new InputField('text', 'nome', 'Nome', (($action=='edit')? $row_se['nome'] : ''));
$field->group = 'Informazioni categoria';
$field->rule  = $obj_rule;
$obj_fm->fields->add($field);

$save = new InputField('submit', 'submit', '', 'Salva');
$obj_fm->fields->add($save);

$obj_validator = new Validator();
$obj_validator->fields = $obj_fm->fields;
if (isset($_POST) && count($_POST))
{
	
	foreach ($obj_fm->fields as $field)
	{
		if (isset($_POST[$field->name]))
		{
			if (is_array($_POST[$field->name]))
			{
				$field->value = $_POST[$field->name];
			}
			else
			{
				$field->value = stripslashes($_POST[$field->name]);
			}
			$obj_categoria->set($field->name, $field->value);
		}
	}

	$res = false;
	$is_valid = $obj_validator->isValid();

	if ($is_valid)
	{
		switch ($action)
		{
		 	case 'insert':
		 		$res = $obj_categoria->insert();
				$str_format = 'Categoria (%s|%d) inserita da (%s|%d).';
		 		break;

		 	case 'edit':
		 		$res = $obj_categoria->update();
				$str_format = 'Categoria (%s|%d) modificata da (%s|%d).';
		 		break;
		}
		if ($res)
		{
		 	$last_id = $obj_categoria->get('ca_id');
			$args = array(
				 $obj_categoria->get('nome')
				,$last_id
				,$ret['uname']
				,$ret['user_id']
			);
			$log = vsprintf($str_format, $args);
			$WebSiteLogObj->WriteMainLog($log);
			header('Location: categorie.php?last_id='. $last_id);
			exit;
		}
		else
		{
			$obj_validator->setCustomError($obj_validator->fields->submit, 'Si è verificato un errore nel salvataggio.');
		}
	}
}



$page_array['form'] = $obj_fm->getForm();
$smarty->assign($page_array);
$smarty->display('generic_form.tpl');
?>
