<?php
include('pagestart.php');

$page_array = array(
	 'page_title' =>'Categorie clienti'
	,'sub_title'  =>'Elenco categorie'
	,'menu2'      =>array(
		array(
			 'page' =>'categorie_edit.php'
			,'title'=>'Aggiungi categoria'
			,'image'=>'shape_square_add.png'
		)
	)
	,'datafilter' =>''
	,'exportlink' =>''
	,'printlink'  =>''
);

$filter = new DataFilter();
$filter->namespace = 'categorie';

$filter->form->fields->add(new InputField('text', 'nome', 'Nome'));
$filter->form->fields->nome->db_name = 'p.nome';

$last_id = 0;
if (isset($_GET['last_id']))
{
	$last_id = $_GET['last_id'];
}

// BEGIN Gestione del where
$ar_sql_add = array();
if ($filter->getWhere())
{
	$ar_sql_add[] = $filter->getWhere();
}
$str_sql_add = implode(' AND ', $ar_sql_add);
// END Gestione del where

$sql = 'SELECT p.*'
	.' FROM '. CATEGORIE_TABLE .' p'
	. (($str_sql_add != '')? ' WHERE ' . $str_sql_add : '');
$obj_dataset = new DataSet($sql, $dbConnOne);
$obj_dataset->order_col = 'nome';
$obj_dataset->order_dir = 'ASC';
$obj_dataset->limit = 40;
$array_data  = $obj_dataset->getData();

$obj_datatable = new DataTable();
$obj_datatable->columns->add(new DataColumn('ca_id',  'ID'));
$obj_datatable->columns->add(new DataColumn('nome',   'Nome'));

$obj_datatable->rows->add($filter->getFilterRow($obj_datatable));
foreach ($array_data as $data)
{
	$row = $obj_datatable->newRow();
	foreach ($data as $k=>$v)
	{
		$row->cells->add(new DataCell($k, $v));
	}
	if ($row->cells->ca_id->value === $last_id)
	{
		$row->css_class = 'tr_highlight';
	}
	$obj_datatable->rows->add($row);
}


$obj_datagrid = new DataGrid($obj_datatable);
$obj_datagrid->caption = 'Record trovati: ' . $obj_dataset->total_items;
$obj_datagrid->pagination = $obj_dataset->getLinks();

$function = new  DataGridFunction('edit', 'categorie_edit.php');
$function->title = 'Modifica Categoria';
$function->image = 'images/shape_square_edit.png';
$obj_datagrid->datagrid_functions->add($function);

$function = new  DataGridFunction('delete', 'categorie_edit.php');
$function->title = 'Elimina Categoria';
$function->onclick = 'return confirm_delete();';
$function->image = 'images/shape_square_delete.png';
$obj_datagrid->datagrid_functions->add($function);


$page_array['datagrid'] = $obj_datagrid->getGrid();
$page_array['exportlink'] = $obj_datagrid->getExportLink($page_array['sub_title']);
$page_array['printlink'] = $obj_datagrid->getPrintLink();

$smarty->assign($page_array);
$smarty->display('generic_datagrid.tpl');
?>
